#define BUTTON A0

#define LED_RUNNING 12
#define LED_STOPPED 13

#define MOTOR_0 7
#define MOTOR_1 8

#define INTERUPT 4

void setup() {
  Serial.begin(115200);

  pinMode(BUTTON, INPUT_PULLUP);
  pinMode(LED_RUNNING, OUTPUT);
  pinMode(LED_STOPPED, OUTPUT);

  pinMode(MOTOR_0, OUTPUT);
  pinMode(MOTOR_1, OUTPUT);

  pinMode(INTERUPT, INPUT);
}

#define TIME_TO_END 5

uint64_t time_previous = 0;
uint64_t time_current = 0;

bool direction = false;
uint8_t state = 0;

bool running = true;

bool button_previous = false;
bool button_current = false;

bool interupted = false;

bool motor_state_0 = false;
bool motor_state_1 = false;
void loop() {
  time_current = millis();
  button_current = digitalRead(BUTTON);
  if (!digitalRead(INTERUPT)) {
    interupted = true;
    running = false;
  }

  if (button_current && !button_previous) {
    running = !running;
    if (running) direction = !direction;

    interupted = false;
  }

  if ((time_current - time_previous) > 1000 && running && !interupted) {
    if (state < TIME_TO_END && direction) {
      state++;
      motor_state_0 = true;
      motor_state_1 = false;
    } //else if (!(state < TIME_TO_END)) direction = !direction;

    if (state > 0 && !direction) {
      state--;
      motor_state_0 = false;
      motor_state_1 = true;
    } //else if (!(state > 0)) direction = !direction;

    time_previous = time_current;
  }

  if (!running || interupted || state == 0 || state == 5) {
    motor_state_0 = false;
    motor_state_1 = false;
  }

  if (state == 0 || state == 5) {
    running = false;
  }
  digitalWrite(MOTOR_0, motor_state_0);
  digitalWrite(MOTOR_1, motor_state_1);

  button_previous = button_current;
  Serial.print("State: ");
  Serial.print(state);
  Serial.print(" | Running: ");
  Serial.print(running);
  Serial.print(" | Interupted: ");
  Serial.print(interupted);
  Serial.print(" | Direction: ");
  Serial.println(direction);
}
