#include <DHT.h>
#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>

#define DHT_PIN 19
#define DHT_TYPE 11

#define SCREEN_WIDTH 128
#define SCREEN_HEIGHT 64

DHT dht(DHT_PIN, DHT_TYPE);
Adafruit_SSD1306 display(SCREEN_WIDTH, SCREEN_HEIGHT, &Wire, -1);

void setup() {
    Serial.begin(115200);
    dht.begin();

    if (!display.begin(SSD1306_SWITCHCAPVCC, 0x3C)) {
        Serial.println(F("SSD1306 allocation failed, restarting..."));
        ESP.restart();
    }
}

String temporary;
void draw(float temperature, float humidity) {
    display.setCursor(0, 0);
    display.setTextSize(1);
    display.setTextColor(SSD1306_WHITE);

    temporary = "Temperature: " + String(temperature) + "'C";
    display.print(temporary);

    display.setCursor(0, SCREEN_HEIGHT / 2);
    display.setTextSize(1);
    display.setTextColor(SSD1306_WHITE);

    temporary = "Humidity: " + String(humidity) + "%";
    display.print(temporary);
}

void loop() {
    display.clearDisplay();

    float temperature = dht.readTemperature();
    float humidity = dht.readHumidity();

    Serial.print("Temperature: ");
    Serial.print(temperature);
    Serial.print(", Humidity: ");
    Serial.print(humidity);
    Serial.print("\n");

    draw(temperature, humidity);

    display.display();
}
