#include <raylib.h>
#include <math.h>

int main(int argc, char **argv) {
    InitWindow(1600, 900, "Evenly Divided Orbiting Text Example");
    SetTargetFPS(60);

    char *things[] = { "P", "A", "T", "H", " ", "Bodo buzi", " ", "O", "F", " ", "Egér buzi", " ", "E", "X", "I", "L", "E", " ", "Mészike buzi", " "};
    const int object_count = sizeof(things) / sizeof(things[0]);

    Vector2 center_position = { 0 };
    Vector2 object_position = { 0 };

    float radius = 300.0f;
    float rotation_angle = 0.0f;
    float rotation_speed = 0.0f;
    int text_size = 40;

    Color background_color = BLACK;
    Color object_color = PINK;

    while (!WindowShouldClose()) {
        center_position = GetMousePosition();

        rotation_angle += rotation_speed;
        if (rotation_angle < 0.0f) {
            rotation_angle = 360.0f;
        } else if (rotation_angle > 360.f) {
            rotation_angle = 0.0f;
        }

        if (GetMouseWheelMove() > 0) {
            rotation_speed += 0.1f;
        }

        if (GetMouseWheelMove() < 0) {
            rotation_speed -= 0.1f;
        }

        BeginDrawing();
        ClearBackground(background_color);

        float angle_increment = 360.0f / object_count;
        for (int i = 0; i < object_count; i++) {
            float angle = rotation_angle + (angle_increment * i);
            object_position.x = center_position.x + cosf(angle * (PI / 180.0f)) * radius;
            object_position.y = center_position.y + sinf(angle * (PI / 180.0f)) * radius;

            if (things[i] != " ") DrawLine(center_position.x, center_position.y, object_position.x, object_position.y, object_color);

            DrawText(things[i], object_position.x - MeasureText(things[i], text_size) / 2, object_position.y - (text_size / 2), text_size, object_color);
            DrawText(TextFormat("Base angle: %.2f", rotation_angle), 10, 10, 20, object_color);
            DrawText(TextFormat("Rotation speed: %.2f", rotation_speed), 10, 30, 20, object_color);
        }

        DrawCircle(center_position.x, center_position.y, 7, object_color);
        EndDrawing();
    }
    
    CloseWindow();
    return 0;
}
