# esp-zigbee-lib

## Introduction
This component contains a binary library supporting the esp-zigbee-lib. It provides most of the APIs that users could use in the Zigbee product project development.  
In this component it provides:  
    + Varieties of ZDO, ZCL command  
    + Standard Home Automation off-the-shelf devices  
    + Zigbee stack related functions to support ZC, ZR and ZED  
    + Varieties of device callback to support device handling ZCL command  
    + Customized function to create attribute, cluster and endpoint  
    + Zigbee security to support install code related function  
    + More to come ... ...  

For the list of current supported ZCL clusters, attributes, commands, Zigbee Home Automation devices, see details [docs](https://docs.espressif.com/projects/esp-zigbee-sdk/en/latest/esp32/developing.html#zigbee-product).

For any new feature requests, please open an [issue](https://github.com/espressif/esp-zigbee-sdk/issues) on GitHub. We will get back to you soon.

## User guide
For a demonstration of the library use, see the examples folder [examples](https://github.com/espressif/esp-zigbee-sdk/tree/main/examples).
For information on how to program Espressif SoCs, see [ESP-IDF Programming Guide](https://docs.espressif.com/projects/esp-idf).
For esp-zigbee-lib related user guide and documents, see [docs](https://docs.espressif.com/projects/esp-zigbee-sdk/).

