#define BUTTON 21
#define POTMETER 22

#define LED_0 23
#define LED_1 4
#define LED_2 5
#define LED_3 18
#define LED_4 19

#define DELAY 1

#define MAX_LEVEL 1000.0f
#define MIN_LEVEL 0.0f
float level = 0.0f;

#define FILL_SPEED 200.0f
#define DRAIN_SPEED 250.0f

void setup() {
    Serial.begin(9600);

    pinMode(BUTTON, INPUT_PULLUP);
    pinMode(POTMETER, INPUT);

    pinMode(LED_0, OUTPUT);
    pinMode(LED_1, OUTPUT);
    pinMode(LED_2, OUTPUT);
    pinMode(LED_3, OUTPUT);
    pinMode(LED_4, OUTPUT);

    while (!Serial) { }
}

uint64_t previous = 0;
bool tick = false;

float mapf(float input, float in_min, float in_max, float out_min, float out_max) {
    const float run = in_max - in_min;
    if (run == 0) {
        log_e("map(): Invalid input range, min == max");
        return -1;
    }
    
    const float rise = out_max - out_min;
    const float delta = input - in_min;
    
    return (delta * rise) / run + out_min;
}

void loop() {
    tick = false;

    uint64_t current = millis();
    if (current - previous > DELAY) {
        tick = true;
        previous = current;
    }
    Serial.print("Level: ");;
    Serial.print(level);

    if (tick && digitalRead(BUTTON)) {
        float remaining = MAX_LEVEL - level;
        Serial.print(", Fill: ");
        Serial.print(remaining);

        if (remaining > FILL_SPEED) {
            level += remaining;
        } else {
            level += FILL_SPEED;
        }
    }

    float potmeter_value = mapf((float) analogRead(POTMETER), 0.0f, 1023.0f, 0.0f, DRAIN_SPEED);
    if (tick && potmeter_value > 3) {
        float remaining = level - MIN_LEVEL;
        Serial.print(", Drain: ");
        Serial.print(potmeter_value);

        if (remaining > DRAIN_SPEED) {
            level -= DRAIN_SPEED;
        } else {
            level -= remaining;
        }
    }

    uint8_t display = mapf(level, MIN_LEVEL, MAX_LEVEL, 0, 5);
    digitalWrite(LED_0, display > 0);
    digitalWrite(LED_1, display > 1);
    digitalWrite(LED_2, display > 2);
    digitalWrite(LED_3, display > 3);
    digitalWrite(LED_4, display > 4);
    Serial.print(", Display: ");
    Serial.print(display);
    Serial.print("\n");
}
