#include <Servo.h>

#define R 6
#define G 5
#define B 3
#define SERVO 9
#define POTMETER_0 A0
#define POTMETER_1 A1

typedef struct Color {
  unsigned char r;
  unsigned char g;
  unsigned char b;
  unsigned char a;
} Color;

Servo servo;

void setup() {
  Serial.begin(9600);

  pinMode(R, OUTPUT);
  pinMode(G, OUTPUT);
  pinMode(B, OUTPUT);

  pinMode(POTMETER_0, INPUT);
  pinMode(POTMETER_1, INPUT);
  servo.attach(SERVO);
}

// don't know how, but it works
float hue_to_rgb(float p, float q, float t) {
    if (t < 0) t += 1;
    if (t > 1) t -= 1;

    if (t < 1.0 / 6.0) return p + (q - p) * 6 * t;
    if (t < 1.0 / 2.0) return q;
    if (t < 2.0 / 3.0) return p + (q - p) * (2.0 / 3.0 - t) * 6;

    return p;
}

// same about this too
Color hsl_to_rgb(float h, float s, float l) {
    float r, g, b;

    if (s == 0) {
        r = g = b = l;
    } else {
        float q = l < 0.5 ? l * (1 + s) : l + s - l * s;
        float p = 2 * l - q;

        r = hue_to_rgb(p, q, h + (1.0 / 3.0));
        g = hue_to_rgb(p, q, h);
        b = hue_to_rgb(p, q, h - (1.0 / 3.0));
    }

    return (Color) { (unsigned char) (r * 255), (unsigned char) (g * 255), (unsigned char) (b * 255), 255 };
}

float mapf(long x, long in_min, long in_max, float out_min, float out_max) {
  return (float) (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;
}

float hue = 0.0f;
const float saturation = 1.0f;
float lightness = 0.5f;
Color test = { 0 };

int potmeter_0_value = 0;
float potmeter_1_value = 0;
void loop() {
  // gigachad color calculating..
  hue += 0.01f;
  if (hue > 1.0f) hue -= 1.0f;

  // brightness
  potmeter_1_value = analogRead(POTMETER_1);
  lightness = mapf(potmeter_1_value, 0, 1023, 0, 0.5);
  test = hsl_to_rgb(hue, saturation, lightness);

  // setting values
  analogWrite(R, test.r);
  analogWrite(G, test.g);
  analogWrite(B, test.b);

  // printing things
  Serial.print("(R: ");
  Serial.print(test.r);
  Serial.print(") (G: ");
  Serial.print(test.g);
  Serial.print(") (B: ");
  Serial.print(test.b);
  Serial.print(") (Lightness: ");
  Serial.print(lightness);
  Serial.print(")\n");

  // servo
  potmeter_0_value = analogRead(POTMETER_0);
  potmeter_0_value = map(potmeter_0_value, 0, 1023, 0, 180);
  servo.write(potmeter_0_value);
  delay(15);
}
