#define R 11
#define G 10
#define B 9

typedef struct Color {
  unsigned char r;
  unsigned char g;
  unsigned char b;
  unsigned char a;
} Color;

void setup() {
  Serial.begin(9600);

  pinMode(R, OUTPUT);
  pinMode(G, OUTPUT);
  pinMode(B, OUTPUT);
}

// don't know how, but it works
float hue_to_rgb(float p, float q, float t) {
    if (t < 0) t += 1;
    if (t > 1) t -= 1;

    if (t < 1.0 / 6.0) return p + (q - p) * 6 * t;
    if (t < 1.0 / 2.0) return q;
    if (t < 2.0 / 3.0) return p + (q - p) * (2.0 / 3.0 - t) * 6;

    return p;
}

// same about this too
Color hsl_to_rgb(float h, float s, float l) {
    float r, g, b;

    if (s == 0) {
        r = g = b = l;
    } else {
        float q = l < 0.5 ? l * (1 + s) : l + s - l * s;
        float p = 2 * l - q;

        r = hue_to_rgb(p, q, h + (1.0 / 3.0));
        g = hue_to_rgb(p, q, h);
        b = hue_to_rgb(p, q, h - (1.0 / 3.0));
    }

    return (Color) { (unsigned char) (r * 255), (unsigned char) (g * 255), (unsigned char) (b * 255), 255 };
}

float hue = 0.0f;
const float saturation = 1.0f;
const float lightness = 0.5f;

Color test = { 0 };
void loop() {
  // gigachad color calculating..
  hue += 0.001f;
  if (hue > 1.0f) hue -= 1.0f;
  test = hsl_to_rgb(hue, saturation, lightness);

  // setting values
  analogWrite(R, test.r);
  analogWrite(G, test.g);
  analogWrite(B, test.b);

  // printing things
  Serial.print(test.r);
  Serial.print(" ");
  Serial.print(test.g);
  Serial.print(" ");
  Serial.print(test.b);
  Serial.print("\n");
}
