/*
 * Decompiled with CFR 0.152.
 */
package me.baks.rpl.mysql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import me.baks.rpl.Files;

public class SQLManager {
    public static boolean MYSQL_ENABLE = Files.mysqlConfig.getBoolean("ENABLE");
    public static boolean MYSQL_SSL = Files.mysqlConfig.getBoolean("SSL");
    public static String MYSQL_HOST = Files.mysqlConfig.getString("HOST", "localhost:3306");
    public static String MYSQL_DATABASE = Files.mysqlConfig.getString("DATABASE", "rpl");
    public static String MYSQL_TABLE = Files.mysqlConfig.getString("TABLE", "players");
    public static String MYSQL_USERNAME = Files.mysqlConfig.getString("USERNAME", "root");
    public static String MYSQL_PASSWORD = Files.mysqlConfig.getString("PASSWORD", "root");
    private static Connection con;

    public SQLManager() {
        SQLManager.connect();
        this.createTable();
    }

    public void createTable() {
        try {
            PreparedStatement preparedStatement = con.prepareStatement("CREATE TABLE IF NOT EXISTS " + MYSQL_TABLE + " (uuid VARCHAR(50) PRIMARY KEY, lastName VARCHAR(50), exp INT(3), points INT(3), level INT(3), str INT(3), sta INT(3), dex INT(3), inta INT(3), lastLogin BIGINT(20))");
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            System.out.println("[RPL MySQL] ===========================================");
            System.err.println("[RPL MySQL] Table 'players'not created!");
            System.out.println("[RPL MySQL] ===========================================");
        }
    }

    public static void connect() {
        try {
            con = DriverManager.getConnection("jdbc:mysql://" + MYSQL_HOST + "/" + MYSQL_DATABASE + "?autoconnect=true&useSSL=" + MYSQL_SSL, MYSQL_USERNAME, MYSQL_PASSWORD);
            System.out.println("[RPL MySQL] ===========================================");
            System.out.println("[RPL MySQL] Connected");
            System.out.println("[RPL MySQL] ===========================================");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void close() {
        try {
            if (con != null) {
                con.close();
                System.out.println("[RPL MySQL] ===========================================");
                System.out.println("[RPL MySQL] Connection closed!");
                System.out.println("[RPL MySQL] ===========================================");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void update(String string) {
        try {
            Statement statement = con.createStatement();
            statement.executeUpdate(string);
            statement.close();
            System.out.println("[RPL MySQL] ===========================================");
            System.out.println("[RPL MySQL] String updated!");
            System.out.println("[RPL MySQL] ===========================================");
        }
        catch (Exception exception) {
            SQLManager.connect();
            exception.printStackTrace();
        }
    }

    public static ResultSet query(String string) {
        ResultSet resultSet = null;
        try {
            Statement statement = con.createStatement();
            resultSet = statement.executeQuery(string);
        }
        catch (Exception exception) {
            SQLManager.connect();
            exception.printStackTrace();
        }
        return resultSet;
    }
}

