/*
 * Decompiled with CFR 0.152.
 */
package me.baks.rpl.manager;

import java.util.ArrayList;
import me.baks.rpl.Main;
import me.baks.rpl.config.ConfigManager;
import me.baks.rpl.manager.Utils;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class UpgradeManager {
    private static Main plugin = Main.plugin;

    public static void openUpgrade1(Player player) {
        Inventory inventory = plugin.getServer().createInventory((InventoryHolder)player, InventoryType.CHEST, ConfigManager.UPGRADE_1_NAME);
        UpgradeManager.upgrade1FILL(inventory);
        player.openInventory(inventory);
    }

    private static void upgrade1FILL(Inventory inventory) {
        ItemStack itemStack = UpgradeManager.getItem();
        ItemStack itemStack2 = UpgradeManager.getStart();
        ItemStack itemStack3 = UpgradeManager.getMoonstone();
        ItemStack itemStack4 = UpgradeManager.getBookInfo();
        inventory.setItem(0, itemStack2);
        inventory.setItem(4, itemStack2);
        inventory.setItem(8, itemStack2);
        inventory.setItem(9, itemStack2);
        inventory.setItem(13, itemStack2);
        inventory.setItem(17, itemStack2);
        inventory.setItem(18, itemStack2);
        inventory.setItem(22, itemStack4);
        inventory.setItem(26, itemStack2);
        inventory.setItem(1, itemStack);
        inventory.setItem(5, itemStack3);
        inventory.setItem(2, itemStack);
        inventory.setItem(6, itemStack3);
        inventory.setItem(3, itemStack);
        inventory.setItem(7, itemStack3);
        inventory.setItem(10, itemStack);
        inventory.setItem(14, itemStack3);
        inventory.setItem(11, null);
        inventory.setItem(15, null);
        inventory.setItem(12, itemStack);
        inventory.setItem(16, itemStack3);
        inventory.setItem(19, itemStack);
        inventory.setItem(23, itemStack3);
        inventory.setItem(20, itemStack);
        inventory.setItem(24, itemStack3);
        inventory.setItem(21, itemStack);
        inventory.setItem(25, itemStack3);
    }

    private static ItemStack getStart() {
        ItemStack itemStack = new ItemStack(Material.GREEN_STAINED_GLASS_PANE);
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(ConfigManager.UPGRADE_1_ITEM_START);
        ArrayList arrayList = new ArrayList();
        itemMeta.setLore(arrayList);
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    private static ItemStack getItem() {
        ItemStack itemStack = new ItemStack(Material.BLACK_STAINED_GLASS_PANE);
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(ConfigManager.UPGRADE_1_ITEM);
        ArrayList arrayList = new ArrayList();
        itemMeta.setLore(arrayList);
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    private static ItemStack getMoonstone() {
        ItemStack itemStack = new ItemStack(Material.BLACK_STAINED_GLASS_PANE);
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(ConfigManager.UPGRADE_1_MOONSTONE_NAME);
        ArrayList arrayList = new ArrayList();
        itemMeta.setLore(arrayList);
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    private static ItemStack getBookInfo() {
        ItemStack itemStack = new ItemStack(Material.BOOK);
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(ConfigManager.UPGRADE_1_BOOK_NAME);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : ConfigManager.UPGRADE_1_BOOK_INFO) {
            string = ChatColor.translateAlternateColorCodes((char)'&', (String)string);
            arrayList.add(string);
        }
        itemMeta.setLore(arrayList);
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public static Boolean upgrade1CheckItem(ItemStack itemStack) {
        if (itemStack != null && itemStack.getType() != Material.AIR) {
            return true;
        }
        return false;
    }

    public static Boolean upgrade1CheckStone(ItemStack itemStack) {
        String string;
        if (itemStack != null && itemStack.getType() != Material.AIR && itemStack.getItemMeta().hasDisplayName() && (string = itemStack.getItemMeta().getDisplayName()).equals(ConfigManager.UPGRADE_1_MOONSTONE_NAME)) {
            return true;
        }
        return false;
    }

    public static ItemStack upgrade1CreateSlot(Player player, ItemStack itemStack) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        ArrayList<String> arrayList = itemMeta.getLore() == null ? new ArrayList<String>() : new ArrayList(itemMeta.getLore());
        int n = 0;
        for (String string : arrayList) {
            if (string.contains(ConfigManager.UPGRADE_SLOTS)) {
                String[] stringArray = ChatColor.stripColor((String)string).split("/");
                int n2 = Integer.parseInt(stringArray[0].replaceAll("\\D", ""));
                int n3 = Integer.parseInt(stringArray[1].replaceAll("\\D", "")) + 1;
                arrayList.set(n, "\u00a7f[" + n2 + "/" + n3 + "] " + ConfigManager.UPGRADE_SLOTS);
                arrayList.add(ConfigManager.UPGRADE_EMPTY_SLOT);
                itemMeta.setLore(arrayList);
                itemStack.setItemMeta(itemMeta);
                return itemStack;
            }
            ++n;
        }
        arrayList.add(" ");
        arrayList.add("\u00a7f[0/1] " + ConfigManager.UPGRADE_SLOTS);
        arrayList.add(ConfigManager.UPGRADE_EMPTY_SLOT);
        itemMeta.setLore(arrayList);
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public static boolean checkSlotLimit(Player player, ItemStack itemStack) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        ArrayList arrayList = itemMeta.getLore() == null ? new ArrayList() : new ArrayList(itemMeta.getLore());
        if (Utils.getSlotLimit(itemStack) <= 0) {
            player.sendMessage(ConfigManager.UPGRADE_1_SLOT_LIMIT);
            return false;
        }
        for (String string : arrayList) {
            String[] stringArray;
            int n;
            if (!string.contains(ConfigManager.UPGRADE_SLOTS) || (n = Integer.parseInt((stringArray = ChatColor.stripColor((String)string).split("/"))[1].replaceAll("\\D", ""))) < Utils.getSlotLimit(itemStack)) continue;
            player.sendMessage(ConfigManager.UPGRADE_1_SLOT_LIMIT);
            return false;
        }
        return true;
    }
}

