/*
 * Decompiled with CFR 0.152.
 */
package me.baks.rpl.manager;

import me.baks.rpl.Main;
import me.baks.rpl.PlayerList;
import me.baks.rpl.actionbar.ActionBar;
import me.baks.rpl.actionbar.ActionBarFormat;
import me.baks.rpl.config.ConfigManager;
import me.baks.rpl.manager.ItemManager;
import me.baks.rpl.manager.StatsManager;
import net.apcat.simplesit.SimpleSitPlayer;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class PowerManager {
    static Main plugin = Main.plugin;

    public PowerManager() {
        new BukkitRunnable(){

            public void run() {
                for (PlayerList playerList : PlayerList.getClasses()) {
                    Player player = plugin.getServer().getPlayer(playerList.getPlayerName());
                    if (player == null) continue;
                    int n = ConfigManager.POWER_VALUE_REGEN;
                    if (PowerManager.plugin.simpleSit && new SimpleSitPlayer(player).isSitting()) {
                        n += ConfigManager.SIT_POWER_MOD;
                    }
                    PowerManager.setPower(player, n);
                }
            }
        }.runTaskTimerAsynchronously((Plugin)plugin, 10L, (long)ConfigManager.POWER_SPEED_REGEN);
    }

    public static void setPower(Player player, int n) {
        String string = player.getName();
        if (!PowerManager.plugin.power.containsKey(player.getName())) {
            PowerManager.plugin.power.put(player.getName(), PowerManager.getMaxPower(player.getName()));
        }
        int n2 = PowerManager.plugin.power.get(string) + n;
        int n3 = PowerManager.getMaxPower(player);
        if (n2 < 10) {
            PowerManager.plugin.power.put(string, 10);
            PotionEffect potionEffect = new PotionEffect(PotionEffectType.BLINDNESS, 30, 1, false, false);
            PotionEffect potionEffect2 = new PotionEffect(PotionEffectType.CONFUSION, 120, 3, false, false);
            player.addPotionEffect(potionEffect);
            player.addPotionEffect(potionEffect2);
            if (ConfigManager.ACTION_BAR_POWER) {
                new ActionBar(player, ActionBarFormat.POWER);
            }
            return;
        }
        if (n2 >= n3) {
            if (PowerManager.plugin.power.get(string) == n3) {
                return;
            }
            PowerManager.plugin.power.put(string, n3);
            if (ConfigManager.ACTION_BAR_POWER) {
                new ActionBar(player, ActionBarFormat.POWER);
            }
            return;
        }
        PowerManager.plugin.power.put(string, n2);
        if (ConfigManager.ACTION_BAR_POWER) {
            new ActionBar(player, ActionBarFormat.POWER);
        }
    }

    public static int getPower(Player player) {
        String string = player.getName();
        if (PowerManager.plugin.power.containsKey(string)) {
            return PowerManager.plugin.power.get(string);
        }
        return 0;
    }

    public static int getPowerProcent(Player player) {
        PlayerList playerList = PlayerList.getByName(player.getName());
        if (playerList == null) {
            return 100;
        }
        String string = player.getName();
        int n = PowerManager.getMaxPower(player);
        int n2 = 0;
        if (PowerManager.plugin.power.containsKey(string)) {
            n2 = PowerManager.plugin.power.get(string);
        }
        return n2 * 100 / n;
    }

    public static int getMaxPower(Player player) {
        PlayerList playerList = PlayerList.getByName(player.getName());
        if (playerList == null) {
            return 100;
        }
        ItemManager.checkItemLevelMainHand(player);
        ItemManager.checkItemLevelOffHand(player);
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        ItemStack itemStack2 = player.getInventory().getItemInOffHand();
        if (!ItemManager.checkMainItemBlackList(itemStack)) {
            itemStack = new ItemStack(Material.AIR);
        }
        if (!ItemManager.checkOffItemBlackList(itemStack2)) {
            itemStack2 = new ItemStack(Material.AIR);
        }
        int n = playerList.getSta() + StatsManager.getSta(itemStack) + StatsManager.getSta(itemStack2) + StatsManager.getStaArmour(player);
        int n2 = ConfigManager.POWER_BAZE_SIZE + StatsManager.getPower(itemStack) + StatsManager.getPower(itemStack2) + StatsManager.getPowerArmour(player) + n * ConfigManager.POWER_PER_STA;
        return n2;
    }

    public static int getMaxPower(String string) {
        Player player = plugin.getServer().getPlayer(string);
        PlayerList playerList = PlayerList.getByName(player.getName());
        if (playerList == null) {
            return 100;
        }
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        ItemStack itemStack2 = player.getInventory().getItemInOffHand();
        if (!ItemManager.checkMainItemBlackList(itemStack)) {
            itemStack = new ItemStack(Material.AIR);
        }
        if (!ItemManager.checkOffItemBlackList(itemStack2)) {
            itemStack2 = new ItemStack(Material.AIR);
        }
        int n = ConfigManager.POWER_BAZE_SIZE + StatsManager.getPower(itemStack) + StatsManager.getPower(itemStack2) + StatsManager.getPowerArmour(player) + playerList.getSta() * ConfigManager.POWER_PER_STA;
        return n;
    }
}

