/*
 * Decompiled with CFR 0.152.
 */
package me.baks.rpl.manager;

import me.baks.rpl.Main;
import me.baks.rpl.PlayerList;
import me.baks.rpl.config.ConfigManager;
import me.baks.rpl.holograms.Hologramm;
import me.baks.rpl.manager.ItemManager;
import me.baks.rpl.manager.KitManager;
import me.baks.rpl.manager.PlayerManager;
import me.baks.rpl.manager.StatsManager;
import me.baks.rpl.manager.Utils;
import me.baks.rpl.particles.ParticleEffects;
import me.baks.rpl.tittlebar.TitleBar;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class PluginManager {
    private static Main plugin = Main.plugin;

    public static void levelUP(Player player) {
        PlayerList playerList = PlayerList.getByName(player.getName());
        if (player == null || playerList == null) {
            return;
        }
        int n = playerList.getPlayerLevel();
        int n2 = playerList.getStatPoints();
        String string = ConfigManager.LEVEL_UP_TITTLE.replace("%playerlevel", "" + n).replace("%statpoints", "" + n2);
        String string2 = ConfigManager.LEVEL_UP_SUBTITTLE.replace("%playerlevel", "" + n).replace("%statpoints", "" + n2);
        new TitleBar(player, 5, 120, 5, string, string2);
        KitManager.giveKit(player, n);
    }

    public static void updatePlayerStats(final Player player, final ItemStack itemStack, final ItemStack itemStack2) {
        new BukkitRunnable(){

            public void run() {
                PluginManager.updatePlayerHealth(player, itemStack, itemStack2);
                PluginManager.updatePlayerWalkSpeed(player, itemStack, itemStack2);
            }
        }.runTask((Plugin)plugin);
    }

    public static void updatePlayerStats(Player player) {
        PluginManager.updatePlayerHealth(player);
        PluginManager.updatePlayerWalkSpeed(player);
    }

    static void updatePlayerWalkSpeed(Player player) {
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        ItemStack itemStack2 = player.getInventory().getItemInOffHand();
        float f = Utils.getSpeed(StatsManager.getWalkSpeed(itemStack) + StatsManager.getWalkSpeed(itemStack2) + StatsManager.getWalkSpeedArmour(player));
        player.setWalkSpeed(f);
    }

    static void updatePlayerWalkSpeed(Player player, ItemStack itemStack, ItemStack itemStack2) {
        float f = Utils.getSpeed(StatsManager.getWalkSpeed(itemStack) + StatsManager.getWalkSpeed(itemStack2) + StatsManager.getWalkSpeedArmour(player));
        player.setWalkSpeed(f);
    }

    static void updatePlayerHealth(Player player, ItemStack itemStack, ItemStack itemStack2) {
        PlayerList playerList = PlayerList.getByName(player.getName());
        if (player == null || playerList == null) {
            return;
        }
        int n = playerList.getSta() + StatsManager.getSta(itemStack) + StatsManager.getSta(itemStack2) + StatsManager.getStaArmour(player);
        if (ConfigManager.HEALTH_BASE + (double)StatsManager.getHealth(itemStack) + (double)StatsManager.getHealth(itemStack2) + (double)StatsManager.getHealthArmour(player) + ConfigManager.HEALTH_PER_STA * (double)n <= 1.0) {
            player.setMaxHealth(1.0);
            player.setHealthScale(2.0);
        } else {
            player.setMaxHealth(ConfigManager.HEALTH_BASE + (double)StatsManager.getHealth(itemStack) + (double)StatsManager.getHealth(itemStack2) + (double)StatsManager.getHealthArmour(player) + ConfigManager.HEALTH_PER_STA * (double)n);
            if (player.getMaxHealth() > ConfigManager.HEALTH_BASE) {
                double d = player.getMaxHealth() - ConfigManager.HEALTH_BASE;
                player.setHealthScale(ConfigManager.HEALTH_SCALE_BASE + (ConfigManager.HEALTH_SCALE_BASE + d) * ConfigManager.HEALTH_SCALSE_MOD);
            } else {
                player.setHealthScale(ConfigManager.HEALTH_SCALE_BASE);
            }
        }
    }

    static void updatePlayerHealth(Player player) {
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        ItemStack itemStack2 = player.getInventory().getItemInOffHand();
        PlayerList playerList = PlayerList.getByName(player.getName());
        if (player == null || playerList == null) {
            return;
        }
        int n = playerList.getSta() + StatsManager.getSta(itemStack) + StatsManager.getSta(itemStack2) + StatsManager.getStaArmour(player);
        if (ConfigManager.HEALTH_BASE + (double)StatsManager.getHealth(itemStack) + (double)StatsManager.getHealth(itemStack2) + (double)StatsManager.getHealthArmour(player) + ConfigManager.HEALTH_PER_STA * (double)n <= 1.0) {
            player.setMaxHealth(1.0);
            player.setHealthScale(2.0);
        } else {
            player.setMaxHealth(ConfigManager.HEALTH_BASE + (double)StatsManager.getHealth(itemStack) + (double)StatsManager.getHealth(itemStack2) + (double)StatsManager.getHealthArmour(player) + ConfigManager.HEALTH_PER_STA * (double)n);
            if (player.getMaxHealth() > ConfigManager.HEALTH_BASE) {
                double d = player.getMaxHealth() - ConfigManager.HEALTH_BASE;
                player.setHealthScale(ConfigManager.HEALTH_SCALE_BASE + (ConfigManager.HEALTH_SCALE_BASE + d) * ConfigManager.HEALTH_SCALSE_MOD);
            } else {
                player.setHealthScale(ConfigManager.HEALTH_SCALE_BASE);
            }
        }
    }

    public static void checkArmourLevel(Player player) {
        PlayerList playerList = PlayerList.getByName(player.getName());
        if (player == null || playerList == null) {
            return;
        }
        int n = playerList.getPlayerLevel();
        ItemStack itemStack = player.getInventory().getHelmet();
        ItemStack itemStack2 = player.getInventory().getChestplate();
        ItemStack itemStack3 = player.getInventory().getLeggings();
        ItemStack itemStack4 = player.getInventory().getBoots();
        if (n < StatsManager.getLevel(itemStack)[0] || n > StatsManager.getLevel(itemStack)[1]) {
            player.getInventory().setHelmet(null);
            ItemManager.addItemPlayer(itemStack, player);
            player.sendMessage(ConfigManager.MESSAGE_GENERAL_ARMOUR_REQUEST_LEVEL.replace("%level", StatsManager.getLevel(itemStack)[0] + "-" + StatsManager.getLevel(itemStack)[1]));
        }
        if (n < StatsManager.getLevel(itemStack2)[0] || n > StatsManager.getLevel(itemStack2)[1]) {
            player.getInventory().setChestplate(null);
            ItemManager.addItemPlayer(itemStack2, player);
            player.sendMessage(ConfigManager.MESSAGE_GENERAL_ARMOUR_REQUEST_LEVEL.replace("%level", StatsManager.getLevel(itemStack2)[0] + "-" + StatsManager.getLevel(itemStack2)[1]));
        }
        if (n < StatsManager.getLevel(itemStack3)[0] || n > StatsManager.getLevel(itemStack3)[1]) {
            player.getInventory().setLeggings(null);
            ItemManager.addItemPlayer(itemStack3, player);
            player.sendMessage(ConfigManager.MESSAGE_GENERAL_ARMOUR_REQUEST_LEVEL.replace("%level", StatsManager.getLevel(itemStack3)[0] + "-" + StatsManager.getLevel(itemStack3)[1]));
        }
        if (n < StatsManager.getLevel(itemStack4)[0] || n > StatsManager.getLevel(itemStack4)[1]) {
            player.getInventory().setBoots(null);
            ItemManager.addItemPlayer(itemStack4, player);
            player.sendMessage(ConfigManager.MESSAGE_GENERAL_ARMOUR_REQUEST_LEVEL.replace("%level", StatsManager.getLevel(itemStack4)[0] + "-" + StatsManager.getLevel(itemStack4)[1]));
        }
    }

    public static void setExp(Player player, int n) {
        while (n > 0) {
            PlayerList playerList = PlayerList.getByName(player.getName());
            int n2 = playerList.getPlayerLevel();
            int n3 = playerList.getExp();
            int[] nArray = PlayerManager.getPlayerValues(player, n2);
            if (nArray[0] == -1) {
                return;
            }
            if (n3 + n >= nArray[0]) {
                n -= nArray[0] - n3;
                PluginManager.addLevel(player, 1);
                continue;
            }
            playerList.setExp(n3 + n);
            n = 0;
        }
    }

    public static void addLevel(Player player, int n) {
        while (1 <= n) {
            PlayerList playerList = PlayerList.getByName(player.getName());
            int n2 = playerList.getPlayerLevel();
            int n3 = playerList.getStatPoints();
            int[] nArray = PlayerManager.getPlayerValues(player, n2);
            if (nArray[0] == -1) {
                return;
            }
            playerList.setExp(0);
            playerList.setPlayerLevel(n2 + 1);
            playerList.setStatPoints(n3 + nArray[1]);
            PluginManager.levelUP(player);
            PluginManager.updatePlayerStats(player);
            --n;
        }
    }

    public static void addStatPoints(Player player, int n) {
        PlayerList playerList = PlayerList.getByName(player.getName());
        int n2 = playerList.getStatPoints();
        playerList.setStatPoints(n2 + n);
    }

    public static void cycle(Entity entity, double d) {
        int n = 12;
        int n2 = 0;
        while (n2 < 360) {
            double d2 = (double)n2 * Math.PI / 180.0;
            double d3 = d * Math.cos(d2);
            double d4 = d * Math.sin(d2);
            Location location = entity.getLocation().add(d3, 1.0, d4);
            ParticleEffects.spawn(location, Particle.FLAME, 1, 1);
            ParticleEffects.spawn(location, Particle.HEART, 1, 1);
            n2 += 360 / n;
        }
    }

    public static void vanish(final Player player) {
        new BukkitRunnable(){

            public void run() {
                PotionEffectType potionEffectType2;
                for (PotionEffectType potionEffectType2 : plugin.getServer().getOnlinePlayers()) {
                    potionEffectType2.hidePlayer(player);
                }
                potionEffectType2 = PotionEffectType.INVISIBILITY;
                player.addPotionEffect(potionEffectType2.createEffect(200, 1));
            }
        }.runTask((Plugin)plugin);
    }

    public static void unVanish(final Player player) {
        new BukkitRunnable(){

            public void run() {
                PotionEffectType potionEffectType2;
                for (PotionEffectType potionEffectType2 : plugin.getServer().getOnlinePlayers()) {
                    potionEffectType2.showPlayer(player);
                }
                potionEffectType2 = PotionEffectType.INVISIBILITY;
                player.removePotionEffect(potionEffectType2);
            }
        }.runTask((Plugin)plugin);
    }

    public static void setLine(Player player, Integer n) {
        Location location = player.getEyeLocation();
        int n2 = 0;
        while (n2 <= n * 2) {
            Vector vector = location.getDirection().multiply(0.5);
            Location location2 = location.add(vector);
            ParticleEffects.spawn(location2, Particle.VILLAGER_HAPPY, 1, 1);
            ++n2;
        }
    }

    public static void getMobTypeHEIGHT(Entity entity) {
        Double d = 0.3;
        switch (entity.getType()) {
            case BAT: {
                d = 0.3;
                break;
            }
            case CAVE_SPIDER: {
                d = -0.7;
                break;
            }
            case CHICKEN: {
                d = -0.7;
                break;
            }
            case COW: {
                d = -0.7;
                break;
            }
            case ENDERMAN: {
                d = 0.4;
                break;
            }
            case ENDERMITE: {
                d = -1.0;
                break;
            }
            case GHAST: {
                d = 0.5;
                break;
            }
            case OCELOT: {
                d = -0.8;
                break;
            }
            case PIG: {
                d = -0.7;
                break;
            }
            case RABBIT: {
                d = -0.7;
                break;
            }
            case SHEEP: {
                d = -0.6;
                break;
            }
            case SILVERFISH: {
                d = -1.0;
                break;
            }
            case SLIME: {
                d = 0.0;
                break;
            }
            case SPIDER: {
                d = -0.7;
                break;
            }
            case SQUID: {
                d = -0.7;
                break;
            }
            case WOLF: {
                d = -0.7;
                break;
            }
            default: {
                d = 0.3;
            }
        }
        Hologramm.HEIGHT = d;
    }
}

