/*
 * Decompiled with CFR 0.152.
 */
package me.baks.rpl.manager;

import me.baks.rpl.Main;
import me.baks.rpl.PlayerList;
import me.baks.rpl.actionbar.ActionBar;
import me.baks.rpl.actionbar.ActionBarFormat;
import me.baks.rpl.config.ConfigManager;
import me.baks.rpl.manager.ItemManager;
import me.baks.rpl.manager.StatsManager;
import net.apcat.simplesit.SimpleSitPlayer;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ManaManager {
    static Main plugin = Main.plugin;

    public ManaManager() {
        new BukkitRunnable(){

            public void run() {
                for (PlayerList playerList : PlayerList.getClasses()) {
                    Player player = plugin.getServer().getPlayer(playerList.getPlayerName());
                    if (player == null) continue;
                    int n = ConfigManager.MANA_VALUE_REGEN;
                    if (ManaManager.plugin.simpleSit && new SimpleSitPlayer(player).isSitting()) {
                        n += ConfigManager.SIT_MANA_MOD;
                    }
                    ManaManager.setMana(player, n);
                }
            }
        }.runTaskTimerAsynchronously((Plugin)plugin, 20L, (long)ConfigManager.MANA_SPEED_REGEN);
    }

    public static void setMana(Player player, int n) {
        String string = player.getName();
        if (!ManaManager.plugin.mana.containsKey(player.getName())) {
            ManaManager.plugin.mana.put(player.getName(), ManaManager.getMaxMana(player.getName()));
        }
        int n2 = ManaManager.plugin.mana.get(string) + n;
        int n3 = ManaManager.getMaxMana(player);
        if (n2 < 0) {
            ManaManager.plugin.mana.put(string, 0);
            if (ConfigManager.ACTION_BAR_MANA) {
                new ActionBar(player, ActionBarFormat.MANA);
            }
            return;
        }
        if (n2 >= n3) {
            if (ManaManager.plugin.mana.get(string) == n3) {
                return;
            }
            ManaManager.plugin.mana.put(string, n3);
            if (ConfigManager.ACTION_BAR_MANA) {
                new ActionBar(player, ActionBarFormat.MANA);
            }
            return;
        }
        ManaManager.plugin.mana.put(string, n2);
        if (ConfigManager.ACTION_BAR_MANA) {
            new ActionBar(player, ActionBarFormat.MANA);
        }
    }

    public static int getMana(Player player) {
        if (ManaManager.plugin.mana.containsKey(player.getName())) {
            return ManaManager.plugin.mana.get(player.getName());
        }
        return 100;
    }

    public static int getMana(String string) {
        if (ManaManager.plugin.mana.containsKey(string)) {
            return ManaManager.plugin.mana.get(string);
        }
        return 100;
    }

    public static int getMaxMana(Player player) {
        PlayerList playerList = PlayerList.getByName(player.getName());
        if (playerList == null) {
            return 100;
        }
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        ItemStack itemStack2 = player.getInventory().getItemInOffHand();
        if (!ItemManager.checkMainItemBlackList(itemStack)) {
            itemStack = new ItemStack(Material.AIR);
        }
        if (!ItemManager.checkOffItemBlackList(itemStack2)) {
            itemStack2 = new ItemStack(Material.AIR);
        }
        int n = playerList.getInt() + StatsManager.getInt(itemStack) + StatsManager.getInt(itemStack2) + StatsManager.getIntArmour(player);
        int n2 = ConfigManager.MANA_BAZE_SIZE + StatsManager.getMana(itemStack) + StatsManager.getMana(itemStack2) + StatsManager.getManaArmour(player) + n * ConfigManager.MANA_PER_INT;
        return n2;
    }

    public static int getMaxMana(String string) {
        Player player = plugin.getServer().getPlayer(string);
        PlayerList playerList = PlayerList.getByName(player.getName());
        if (playerList == null) {
            return 100;
        }
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        ItemStack itemStack2 = player.getInventory().getItemInOffHand();
        if (!ItemManager.checkMainItemBlackList(itemStack)) {
            itemStack = new ItemStack(Material.AIR);
        }
        if (!ItemManager.checkOffItemBlackList(itemStack2)) {
            itemStack2 = new ItemStack(Material.AIR);
        }
        int n = ConfigManager.MANA_BAZE_SIZE + StatsManager.getMana(itemStack) + StatsManager.getMana(itemStack2) + StatsManager.getManaArmour(player) + playerList.getInt() * ConfigManager.MANA_PER_INT;
        return n;
    }
}

