/*
 * Decompiled with CFR 0.152.
 */
package me.baks.rpl.manager;

import me.baks.rpl.Files;
import me.baks.rpl.Main;
import me.baks.rpl.PlayerList;
import me.baks.rpl.config.ConfigManager;
import me.baks.rpl.manager.StatsManager;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemManager {
    static Main plugin = Main.plugin;

    public static boolean checkMainItemBlackList(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        String string = itemStack.getType().toString();
        for (String string2 : Files.mainhandConfig.getStringList("ItemsBlackList")) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return false;
        }
        return true;
    }

    public static boolean checkOffItemBlackList(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        String string = itemStack.getType().toString();
        for (String string2 : Files.offhandConfig.getStringList("ItemsBlackList")) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return false;
        }
        return true;
    }

    public static double getItemDamage(ItemStack itemStack) {
        if (!ConfigManager.VANILLA_DAMAGE) {
            return Files.damageConfig.getDouble("Damage.DEFAULT");
        }
        for (String string : Files.damageConfig.getConfigurationSection("Damage").getValues(false).keySet()) {
            if (string.equalsIgnoreCase("DEFAULT") || string.equalsIgnoreCase("VanillaDamage") || !itemStack.getType().toString().equalsIgnoreCase(string)) continue;
            double d = Files.damageConfig.getDouble("Damage." + string);
            return d;
        }
        return Files.damageConfig.getDouble("Damage.DEFAULT");
    }

    public static double getDamageAll(ItemStack itemStack, double d) {
        ItemMeta itemMeta;
        if (itemStack != null && itemStack.getType() != Material.AIR && itemStack.hasItemMeta() && itemStack.getItemMeta().hasEnchants() && (itemMeta = itemStack.getItemMeta()).getEnchants().containsKey(Enchantment.DAMAGE_ALL)) {
            int n = itemMeta.getEnchantLevel(Enchantment.DAMAGE_ALL);
            return d * (double)(n * ConfigManager.ENCHANT_DAMAGE_MODIFIER_SHARPNESS) / 100.0;
        }
        return 0.0;
    }

    public static double getDamageArrow(ItemStack itemStack, double d) {
        ItemMeta itemMeta;
        if (itemStack != null && itemStack.getType() != Material.AIR && itemStack.hasItemMeta() && itemStack.getItemMeta().hasEnchants() && (itemMeta = itemStack.getItemMeta()).getEnchants().containsKey(Enchantment.ARROW_DAMAGE)) {
            int n = itemMeta.getEnchantLevel(Enchantment.ARROW_DAMAGE);
            return d * (double)(n * ConfigManager.ENCHANT_DAMAGE_MODIFIER_ARROW) / 100.0;
        }
        return 0.0;
    }

    public static void setItemAmount(Inventory inventory, ItemStack itemStack, int n) {
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return;
        }
        if (itemStack.getAmount() + n <= 0) {
            inventory.remove(itemStack);
        } else {
            itemStack.setAmount(itemStack.getAmount() + n);
        }
    }

    public static void addItemPlayer(ItemStack itemStack, Player player) {
        PlayerInventory playerInventory = player.getInventory();
        int n = 9;
        while (n < 36) {
            ItemStack itemStack2 = playerInventory.getItem(n);
            if (itemStack2 == null) {
                playerInventory.setItem(n, itemStack);
                return;
            }
            ++n;
        }
        Location location = player.getLocation();
        location.getWorld().dropItem(location, itemStack);
    }

    public static void addItemPlayer(ItemStack itemStack, Player player, int n) {
        PlayerInventory playerInventory = player.getInventory();
        if (itemStack == null & itemStack.getType() == Material.AIR) {
            return;
        }
        itemStack.setAmount(n);
        if (playerInventory.firstEmpty() >= 0) {
            playerInventory.setItem(playerInventory.firstEmpty(), itemStack);
        } else {
            Location location = player.getLocation();
            location.getWorld().dropItem(location, new ItemStack(itemStack));
        }
    }

    public static void checkItemLevelMainHand(Player player) {
        if (player == null || !player.isOnline()) {
            return;
        }
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return;
        }
        PlayerList playerList = PlayerList.getByName(player.getName());
        try {
            if (playerList.getPlayerLevel() < StatsManager.getLevel(itemStack)[0] || playerList.getPlayerLevel() > StatsManager.getLevel(itemStack)[1]) {
                ItemManager.addItemPlayer(itemStack, player);
                player.getInventory().setItemInMainHand(new ItemStack(Material.AIR));
                player.sendMessage(ConfigManager.MESSAGE_GENERAL_ITEM_REQUEST_LEVEL.replace("%level", StatsManager.getLevel(itemStack)[0] + "-" + StatsManager.getLevel(itemStack)[1]));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void checkItemLevelOffHand(Player player) {
        if (player == null || !player.isOnline()) {
            return;
        }
        ItemStack itemStack = player.getInventory().getItemInOffHand();
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return;
        }
        PlayerList playerList = PlayerList.getByName(player.getName());
        try {
            if (playerList.getPlayerLevel() < StatsManager.getLevel(itemStack)[0] || playerList.getPlayerLevel() > StatsManager.getLevel(itemStack)[1]) {
                ItemManager.addItemPlayer(itemStack, player);
                player.getInventory().setItemInOffHand(new ItemStack(Material.AIR));
                player.sendMessage(ConfigManager.MESSAGE_GENERAL_ITEM_REQUEST_LEVEL.replace("%level", StatsManager.getLevel(itemStack)[0] + "-" + StatsManager.getLevel(itemStack)[1]));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

