/*
 * Decompiled with CFR 0.152.
 */
package me.baks.rpl.manager;

import java.util.ArrayList;
import me.baks.rpl.Main;
import me.baks.rpl.config.ConfigManager;
import me.baks.rpl.manager.StatsManager;
import me.baks.rpl.manager.Utils;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class DurabilityManager {
    static Main plugin = Main.plugin;

    public void itemDurability(Player player, ItemStack itemStack) {
        if (itemStack != null && itemStack.getType() != Material.AIR) {
            if (Utils.checkEnchDurability(itemStack)) {
                return;
            }
            if (StatsManager.getUndestructible(itemStack)) {
                this.repairItem(itemStack);
                return;
            }
            int[] nArray = StatsManager.getDurability(itemStack);
            if (nArray == null) {
                return;
            }
            int n = nArray[0];
            if (n <= 1) {
                player.getInventory().removeItem(new ItemStack[]{itemStack});
                if (player.getInventory().getHelmet() != null && player.getInventory().getHelmet().equals((Object)itemStack)) {
                    player.getInventory().setHelmet(new ItemStack(Material.AIR));
                }
                if (player.getInventory().getChestplate() != null && player.getInventory().getChestplate().equals((Object)itemStack)) {
                    player.getInventory().setChestplate(new ItemStack(Material.AIR));
                }
                if (player.getInventory().getLeggings() != null && player.getInventory().getLeggings().equals((Object)itemStack)) {
                    player.getInventory().setLeggings(new ItemStack(Material.AIR));
                }
                if (player.getInventory().getBoots() != null && player.getInventory().getBoots().equals((Object)itemStack)) {
                    player.getInventory().setBoots(new ItemStack(Material.AIR));
                }
            } else {
                this.setDurability(itemStack);
            }
        }
    }

    public void skullDurability(Player player, ItemStack itemStack) {
        if (itemStack != null && itemStack.getType() == Material.PLAYER_HEAD) {
            if (Utils.checkEnchDurability(itemStack)) {
                return;
            }
            if (StatsManager.getUndestructible(itemStack)) {
                this.repairSkull(itemStack);
                return;
            }
            int[] nArray = StatsManager.getDurability(itemStack);
            if (nArray == null) {
                return;
            }
            int n = nArray[0];
            if (n <= 1) {
                player.getInventory().setHelmet(new ItemStack(Material.AIR));
            } else {
                this.setSkullDurability(itemStack);
            }
        }
    }

    public void setDurability(ItemStack itemStack) {
        int[] nArray = StatsManager.getDurability(itemStack);
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = nArray[2];
        ItemMeta itemMeta = itemStack.getItemMeta();
        ArrayList<String> arrayList = new ArrayList<String>(itemMeta.getLore());
        arrayList.set(n3, "\u00a78" + ConfigManager.STATS_DURABILITY + ": \u00a77" + (n - 1) + "\u00a78/\u00a77" + n2);
        itemMeta.setLore(arrayList);
        itemStack.setItemMeta(itemMeta);
        if (!this.checkBlackList(itemStack)) {
            short s = itemStack.getType().getMaxDurability();
            itemStack.setDurability((short)this.vanilaDurability(s, n, n2));
        }
    }

    public void setSkullDurability(ItemStack itemStack) {
        int[] nArray = StatsManager.getDurability(itemStack);
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = nArray[2];
        SkullMeta skullMeta = (SkullMeta)itemStack.getItemMeta();
        ArrayList<String> arrayList = new ArrayList<String>(skullMeta.getLore());
        arrayList.set(n3, "\u00a78" + ConfigManager.STATS_DURABILITY + ": \u00a77" + (n - 1) + "\u00a78/\u00a77" + n2);
        skullMeta.setLore(arrayList);
        itemStack.setItemMeta((ItemMeta)skullMeta);
    }

    private int vanilaDurability(int n, int n2, int n3) {
        int n4 = n2 * 100 / n3;
        int n5 = n4 * n / 100;
        return n - n5;
    }

    public void repairItem(ItemStack itemStack) {
        if (itemStack != null) {
            if (!this.checkBlackList(itemStack)) {
                itemStack.setDurability((short)-1);
            }
            if (StatsManager.getDurability(itemStack) != null) {
                int[] nArray = StatsManager.getDurability(itemStack);
                int n = nArray[1];
                int n2 = nArray[2];
                ItemMeta itemMeta = itemStack.getItemMeta();
                ArrayList<String> arrayList = new ArrayList<String>(itemMeta.getLore());
                arrayList.set(n2, "\u00a78" + ConfigManager.STATS_DURABILITY + ": \u00a77" + n + "\u00a78/\u00a77" + n);
                itemMeta.setLore(arrayList);
                itemStack.setItemMeta(itemMeta);
            }
        }
    }

    public void repairSkull(ItemStack itemStack) {
        if (itemStack != null && StatsManager.getDurability(itemStack) != null) {
            int[] nArray = StatsManager.getDurability(itemStack);
            int n = nArray[1];
            int n2 = nArray[2];
            SkullMeta skullMeta = (SkullMeta)itemStack.getItemMeta();
            ArrayList<String> arrayList = new ArrayList<String>(skullMeta.getLore());
            arrayList.set(n2, "\ufffd8" + ConfigManager.STATS_DURABILITY + ": \ufffd7" + n + "\ufffd8/\ufffd7" + n);
            skullMeta.setLore(arrayList);
            itemStack.setItemMeta((ItemMeta)skullMeta);
        }
    }

    public boolean checkBlackList(ItemStack itemStack) {
        for (String string : ConfigManager.REPAIR_BLACK_LIST) {
            if (!itemStack.getType().toString().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }
}

