/*
 * Decompiled with CFR 0.152.
 */
package me.baks.rpl.manager;

import java.util.HashMap;
import me.baks.rpl.Main;
import me.baks.rpl.PlayerList;
import me.baks.rpl.config.ConfigManager;
import me.baks.rpl.manager.Utils;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class BossBarHealth {
    static Main plugin = Main.plugin;
    static HashMap<String, BossBar> list = new HashMap();

    public BossBarHealth() {
        new BukkitRunnable(){

            public void run() {
                for (PlayerList playerList : PlayerList.getClasses()) {
                    Player player = plugin.getServer().getPlayer(playerList.getPlayerName());
                    if (player == null) continue;
                    BossBarHealth.updatePlayerBar(player);
                }
            }
        }.runTaskTimer((Plugin)plugin, 20L, 20L);
    }

    public static void createPlayerBar(Player player) {
        if (!ConfigManager.BOSS_BAR_ENABLE) {
            return;
        }
        BossBar bossBar = plugin.getServer().createBossBar(BossBarHealth.getName(player), ConfigManager.BOSS_BAR_COLOR, ConfigManager.BOSS_BAR_STYLE, new BarFlag[0]);
        bossBar.addPlayer(player);
        BossBarHealth.setValues(player, bossBar);
        list.put(player.getName(), bossBar);
    }

    public static void removePlayerBar(Player player) {
        if (!ConfigManager.BOSS_BAR_ENABLE) {
            return;
        }
        if (!list.containsKey(player.getName())) {
            return;
        }
        BossBar bossBar = list.get(player.getName());
        for (Player player2 : bossBar.getPlayers()) {
            bossBar.removePlayer(player2);
        }
        list.remove(player.getName());
    }

    public static void updatePlayerBar(Player player) {
        if (list.containsKey(player.getName())) {
            BossBar bossBar = list.get(player.getName());
            BossBarHealth.setValues(player, bossBar);
        }
    }

    private static void setBarProgress(BossBar bossBar, Player player) {
        double d = player.getHealth() * 100.0 / player.getMaxHealth() / 100.0;
        if (d < 0.0) {
            d = 0.0;
        } else if (d > 1.0) {
            d = 1.0;
        }
        bossBar.setProgress(d);
    }

    private static void setValues(Player player, BossBar bossBar) {
        bossBar.setTitle(BossBarHealth.getName(player));
        BossBarHealth.setBarProgress(bossBar, player);
    }

    private static String getName(Player player) {
        double d = Utils.roundDouble(player.getHealth());
        String string = ConfigManager.BOSS_BAR_HEALTH.replace("%v1", "" + d);
        string = string.replace("%v2", "" + (int)player.getMaxHealth());
        return string;
    }
}

