/*
 * Decompiled with CFR 0.152.
 */
package me.baks.rpl.actionbar;

import me.baks.rpl.actionbar.ActionBarFormat;
import me.baks.rpl.config.ConfigManager;
import me.baks.rpl.manager.ManaManager;
import me.baks.rpl.manager.PowerManager;
import net.minecraft.server.v1_13_R2.ChatMessageType;
import net.minecraft.server.v1_13_R2.IChatBaseComponent;
import net.minecraft.server.v1_13_R2.Packet;
import net.minecraft.server.v1_13_R2.PacketPlayOutChat;
import org.bukkit.craftbukkit.v1_13_R2.entity.CraftPlayer;
import org.bukkit.entity.Player;

public class ActionBar {
    static String format = ActionBar.getFormat();

    public ActionBar(Player player, ActionBarFormat actionBarFormat) {
        String string = null;
        if (actionBarFormat == ActionBarFormat.POWER) {
            string = ActionBar.messagePower(player);
        } else if (actionBarFormat == ActionBarFormat.MANA) {
            string = ActionBar.messageMana(player);
        }
        this.actionBar(player, string);
    }

    public void actionBar(Player player, String string) {
        IChatBaseComponent iChatBaseComponent = IChatBaseComponent.ChatSerializer.a((String)("{\"text\": \"" + string + "\"}"));
        PacketPlayOutChat packetPlayOutChat = new PacketPlayOutChat(iChatBaseComponent, ChatMessageType.GAME_INFO);
        ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)packetPlayOutChat);
    }

    private static String getFormat() {
        StringBuilder stringBuilder = new StringBuilder("");
        int n = 0;
        while (n < ConfigManager.ACTION_BAR_LENGTH) {
            stringBuilder.insert(n, ConfigManager.ACTION_BAR_SYMBOL);
            ++n;
        }
        return stringBuilder.toString();
    }

    private static String messagePower(Player player) {
        StringBuilder stringBuilder;
        int n = PowerManager.getPowerProcent(player);
        int n2 = n * (stringBuilder = new StringBuilder(format)).length() / 100;
        if (n2 >= stringBuilder.length()) {
            stringBuilder.insert(stringBuilder.length(), ConfigManager.ACTION_BAR_SPLIT);
        } else {
            stringBuilder.insert(n2, ConfigManager.ACTION_BAR_SPLIT);
        }
        String string = ConfigManager.MESSAGE_GENERAL_POWER.replace("%value", stringBuilder.toString());
        string = string.replace("%procent", "" + n);
        return string;
    }

    private static String messageMana(Player player) {
        StringBuilder stringBuilder;
        int n = ManaManager.getMana(player) * 100 / ManaManager.getMaxMana(player);
        int n2 = n * (stringBuilder = new StringBuilder(format)).length() / 100;
        if (n2 >= stringBuilder.length()) {
            stringBuilder.insert(stringBuilder.length(), ConfigManager.ACTION_BAR_SPLIT);
        } else {
            stringBuilder.insert(n2, ConfigManager.ACTION_BAR_SPLIT);
        }
        String string = ConfigManager.MESSAGE_GENERAL_MANA.replace("%value", stringBuilder.toString());
        string = string.replace("%procent", "" + n);
        return string;
    }
}

