/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Set;
import org.jooq.CommonTableExpression;
import org.jooq.Context;
import org.jooq.DerivedColumnList;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.ResultQuery;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.TableOptions;
import org.jooq.impl.AbstractTable;
import org.jooq.impl.DSL;
import org.jooq.impl.DerivedColumnListImpl;
import org.jooq.impl.FieldsImpl;
import org.jooq.impl.FieldsTrait;
import org.jooq.impl.Keywords;
import org.jooq.impl.QOM;
import org.jooq.impl.Tools;
import org.jooq.impl.Transformations;

final class CommonTableExpressionImpl<R extends Record>
extends AbstractTable<R>
implements CommonTableExpression<R> {
    private static final Set<SQLDialect> SUPPORT_MATERIALIZED = SQLDialect.supportedBy(SQLDialect.POSTGRES, SQLDialect.SQLITE);
    private final DerivedColumnListImpl name;
    private final ResultQuery<R> query;
    private final FieldsImpl<R> fields;
    private final QOM.Materialized materialized;

    CommonTableExpressionImpl(DerivedColumnListImpl name, ResultQuery<R> query, QOM.Materialized materialized) {
        super(TableOptions.expression(), name.name);
        this.name = name;
        this.query = query;
        this.fields = this.fields1();
        this.materialized = materialized;
    }

    @Override
    public final Class<? extends R> getRecordType() {
        return this.query.getRecordType();
    }

    @Override
    public final boolean declaresCTE() {
        return true;
    }

    @Override
    public final boolean declaresTables() {
        return true;
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (ctx.declareCTE()) {
            ResultQuery<R> s = this.query;
            ctx.visit(this.name);
            ctx.sql(' ').visit(Keywords.K_AS).sql(' ');
            Object previous = null;
            if (this.materialized != null && SUPPORT_MATERIALIZED.contains((Object)ctx.dialect())) {
                if (this.materialized == QOM.Materialized.MATERIALIZED) {
                    ctx.visit(Keywords.K_MATERIALIZED).sql(' ');
                } else {
                    ctx.visit(Keywords.K_NOT).sql(' ').visit(Keywords.K_MATERIALIZED).sql(' ');
                }
            }
            Tools.visitSubquery(ctx, s, 1);
        } else if (!(ctx.declareTables() && this.query instanceof Select && Transformations.transformInlineCTE(ctx.configuration()))) {
            ctx.visit(this.name.name);
        }
    }

    @Override
    final FieldsImpl<R> fields0() {
        return this.fields;
    }

    final FieldsImpl<R> fields1() {
        Field<?>[] s = FieldsImpl.fieldsRow0((FieldsTrait)((Object)this.query)).fields();
        Field[] f = new Field[Tools.degree(this.query)];
        for (int i = 0; i < f.length; ++i) {
            f[i] = DSL.field(DSL.name(this.name.name, this.name.fieldNames.length > 0 ? this.name.fieldNames[i] : s[i].getUnqualifiedName()), f.length == 1 ? Tools.scalarType(this.query) : s[i].getDataType());
        }
        return new FieldsImpl(f);
    }

    @Override
    public final DerivedColumnList $derivedColumnList() {
        return this.name;
    }

    @Override
    public final ResultQuery<R> $query() {
        return this.query;
    }

    @Override
    public final QOM.Materialized $materialized() {
        return this.materialized;
    }
}

