/*
 * Decompiled with CFR 0.152.
 */
package me.ceze88.vortexcore.libs.org.simpleyaml.configuration.comments.format;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.ceze88.vortexcore.libs.org.simpleyaml.configuration.comments.CommentType;
import me.ceze88.vortexcore.libs.org.simpleyaml.configuration.comments.KeyTree;
import me.ceze88.vortexcore.libs.org.simpleyaml.configuration.comments.format.CommentFormatterConfiguration;
import me.ceze88.vortexcore.libs.org.simpleyaml.utils.StringUtils;

public interface CommentFormatter {
    public String parse(Reader var1, CommentType var2, KeyTree.Node var3) throws IOException;

    public String dump(String var1, CommentType var2, KeyTree.Node var3);

    default public String parse(String raw, CommentType type, KeyTree.Node node) throws IOException {
        return this.parse(new StringReader(raw), type, node);
    }

    default public String parse(Reader raw, CommentType type) throws IOException {
        return this.parse(raw, type, null);
    }

    default public String parse(String raw, CommentType type) throws IOException {
        return this.parse(raw, type, null);
    }

    default public String parse(Reader raw) throws IOException {
        return this.parse(raw, CommentType.BLOCK);
    }

    default public String parse(String raw) throws IOException {
        return this.parse(raw, CommentType.BLOCK);
    }

    default public String dump(String comment, CommentType type) {
        return this.dump(comment, type, null);
    }

    default public String dump(String comment) {
        return this.dump(comment, CommentType.BLOCK);
    }

    public static String format(int indent, String prefixFirst, String prefixMultiline, String comment, CommentType type, String suffixMultiline, String suffixLast) {
        if (comment == null) {
            return "";
        }
        Stream<String> stream = Arrays.stream(StringUtils.lines(comment, comment.trim().isEmpty()));
        String indentation = StringUtils.indentation(indent);
        String indentLine = "\n" + indentation;
        String delimiter = suffixMultiline == null ? indentLine : String.join((CharSequence)indentLine, StringUtils.lines(suffixMultiline, false)) + indentLine;
        prefixFirst = prefixFirst == null ? "" : String.join((CharSequence)indentLine, StringUtils.lines(prefixFirst, false));
        prefixMultiline = prefixMultiline == null ? prefixFirst : String.join((CharSequence)indentLine, StringUtils.lines(prefixMultiline, false));
        if (type == CommentType.BLOCK) {
            prefixFirst = indentation + prefixFirst;
        }
        delimiter = delimiter + prefixMultiline;
        suffixLast = suffixLast == null ? "" : String.join((CharSequence)indentLine, StringUtils.lines(suffixLast, false));
        return stream.collect(Collectors.joining(delimiter, prefixFirst, suffixLast));
    }

    public static String format(String prefixFirst, String prefixMultiline, String comment, String suffixMultiline, String suffixLast) {
        return CommentFormatter.format(0, prefixFirst, prefixMultiline, comment, CommentType.BLOCK, suffixMultiline, suffixLast);
    }

    public static String format(int indent, String comment, CommentType type, CommentFormatterConfiguration configuration) {
        return CommentFormatter.format(indent, configuration.prefixFirst(), configuration.prefixMultiline(), comment, type, configuration.suffixMultiline(), configuration.suffixLast());
    }
}

