/*
 * Decompiled with CFR 0.152.
 */
package me.ceze88.vortexcore.hooks.holo;

import eu.decentsoftware.holograms.api.DHAPI;
import eu.decentsoftware.holograms.api.DecentHolograms;
import eu.decentsoftware.holograms.api.DecentHologramsAPI;
import eu.decentsoftware.holograms.api.holograms.Hologram;
import eu.decentsoftware.holograms.api.holograms.HologramLine;
import eu.decentsoftware.holograms.api.holograms.HologramPage;
import java.util.List;
import me.ceze88.vortexcore.VortexCore;
import me.ceze88.vortexcore.VortexPlugin;
import me.ceze88.vortexcore.hooks.PluginHook;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.jetbrains.annotations.Nullable;

public class HologramHook
implements PluginHook {
    private boolean enabled = false;
    private DecentHolograms hologramsAPI;
    private static final String HOLOGRAM_ID_PREFIX = VortexPlugin.getInstance().getName() + "_";

    public HologramHook() {
        if (Bukkit.getPluginManager().isPluginEnabled("DecentHolograms")) {
            this.hologramsAPI = DecentHologramsAPI.get();
            this.enabled = true;
        }
    }

    @Override
    public String getIdentifier() {
        return "Hologram";
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void onEnable() {
        if (!this.enabled) {
            return;
        }
        VortexCore.getPlugin().getLogger().info("Hooked into DecentHolograms!");
    }

    @Override
    public void onDisable() {
        if (!this.enabled) {
            return;
        }
        this.hologramsAPI.getHologramManager().getHolograms().stream().map(Hologram::getId).filter(s -> s.startsWith(HOLOGRAM_ID_PREFIX)).forEach(s -> this.hologramsAPI.getHologramManager().getHologram(s).delete());
    }

    private String createHologramId(String id) {
        return HOLOGRAM_ID_PREFIX + id;
    }

    @Nullable
    public Hologram createHologram(String id, Location location, List<String> lines) {
        if (!this.enabled) {
            return null;
        }
        return DHAPI.createHologram((String)this.createHologramId(id), (Location)location, lines);
    }

    public void updateHologram(String id, List<String> lines) {
        if (!this.enabled) {
            return;
        }
        Hologram hologram = this.hologramsAPI.getHologramManager().getHologram(this.createHologramId(id));
        if (hologram == null) {
            return;
        }
        HologramPage page = hologram.getPage(0);
        for (int i = 0; i < lines.size(); ++i) {
            HologramLine line = page.getLine(i);
            if (line == null) {
                page.addLine(new HologramLine(null, page.getNextLineLocation(), lines.get(i)));
                continue;
            }
            line.setText(lines.get(i));
        }
    }

    public void updateLine(String id, int line, String text) {
        if (!this.enabled) {
            return;
        }
        Hologram hologram = this.hologramsAPI.getHologramManager().getHologram(this.createHologramId(id));
        if (hologram == null) {
            return;
        }
        HologramPage page = hologram.getPage(0);
        HologramLine hologramLine = page.getLine(line);
        if (hologramLine == null) {
            page.addLine(new HologramLine(null, page.getNextLineLocation(), text));
        } else {
            hologramLine.setText(text);
        }
    }

    public void createOrUpdateHologram(String id, Location location, List<String> lines) {
        if (!this.enabled) {
            return;
        }
        Hologram hologram = this.hologramsAPI.getHologramManager().getHologram(this.createHologramId(id));
        if (hologram == null) {
            this.createHologram(id, location, lines);
        } else {
            this.updateHologram(id, lines);
        }
    }

    public void deleteHologram(String id) {
        if (!this.enabled) {
            return;
        }
        this.hologramsAPI.getHologramManager().getHologram(this.createHologramId(id)).delete();
    }
}

