/*
 * Decompiled with CFR 0.152.
 */
package me.ceze88.vortexcore.database;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.pool.HikariPool;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import me.ceze88.vortexcore.VortexPlugin;
import me.ceze88.vortexcore.config.Config;
import me.ceze88.vortexcore.database.Data;
import me.ceze88.vortexcore.database.DataMigration;
import me.ceze88.vortexcore.database.DatabaseConnector;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Record;
import org.jooq.Record1;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.TableLike;
import org.jooq.impl.DSL;

public class DataManager
implements DatabaseConnector {
    private VortexPlugin plugin;
    private HikariConfig hikariConfig;
    private HikariPool hikariPool;
    private List<DataMigration> migrations;
    protected final ExecutorService asyncPool = new ThreadPoolExecutor(1, 5, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat(this.getClass().getSimpleName() + "-Database-Async-%d").build());

    public DataManager(VortexPlugin plugin) {
        this.plugin = plugin;
    }

    public void init(DataMigration ... migrations) {
        this.migrations = List.of(migrations);
        Config databaseConfig = new Config("database.yml");
        String host = databaseConfig.getString("Connection Settings.Hostname");
        int port = databaseConfig.getInt("Connection Settings.Port");
        String database = databaseConfig.getString("Connection Settings.Database");
        String username = databaseConfig.getString("Connection Settings.Username");
        String password = databaseConfig.getString("Connection Settings.Password");
        int maxConnections = databaseConfig.getInt("Connection Settings.Pool Size");
        if (host == null || port == 0 || database == null || username == null || password == null || maxConnections == 0) {
            throw new IllegalArgumentException("Invalid database configuration. Please set up the database.yml file correctly.");
        }
        this.hikariConfig = new HikariConfig();
        this.hikariConfig.setJdbcUrl("jdbc:mysql://" + host + ":" + port + "/" + database);
        this.hikariConfig.setUsername(username);
        this.hikariConfig.setPassword(password);
        this.hikariConfig.setMaximumPoolSize(maxConnections);
        this.hikariPool = new HikariPool(this.hikariConfig);
        try {
            this.runMigrations();
        }
        catch (SQLException ex) {
            this.plugin.getLogger().severe("Failed to run migrations: " + ex.getMessage());
        }
    }

    public long getNextId(String table) {
        AtomicReference<Long> id = new AtomicReference<Long>(0L);
        this.connectDSL((DSLContext context) -> id.set((Long)((Object)Objects.requireNonNull((Record1)context.select(DSL.field("id")).from((TableLike<?>)DSL.table(this.getTablePrefix() + table)).orderBy(DSL.field("id").desc()).limit(1).fetchOne()).into(Long.class))));
        return id.get() + 1L;
    }

    @Override
    public Connection getConnection() {
        try {
            return this.hikariPool.getConnection();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to get database connection", e);
        }
    }

    @Override
    public void connect(DatabaseConnector.VoidConnection connection) {
        try (Connection conn = this.getConnection();){
            connection.connect(conn);
        }
        catch (Exception ex) {
            this.plugin.getLogger().severe("Failed database connection: " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T connect(DatabaseConnector.ConnectionResult<T> connection) {
        try (Connection conn = this.getConnection();){
            T t = connection.connect(conn);
            return t;
        }
        catch (Exception ex) {
            this.plugin.getLogger().severe("Failed database connection: " + ex.getMessage());
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public void connectDSL(DatabaseConnector.VoidDSLConnection connection) {
        try (Connection conn = this.getConnection();){
            connection.connect(DSL.using(conn));
        }
        catch (Exception ex) {
            this.plugin.getLogger().severe("Failed database connection: " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T connectDSL(DatabaseConnector.DSLConnectionResult<T> connection) {
        try (Connection conn = this.getConnection();){
            T t = connection.connect(DSL.using(conn));
            return t;
        }
        catch (Exception ex) {
            this.plugin.getLogger().severe("Failed database connection: " + ex.getMessage());
            ex.printStackTrace();
            return null;
        }
    }

    public void runMigrations() throws SQLException {
        try (Connection connection = this.getConnection();){
            PreparedStatement statement;
            boolean migrationsExist;
            int currentMigration = -1;
            try {
                connection.createStatement().execute("SELECT 1 FROM " + this.getMigrationsTableName());
                migrationsExist = true;
            }
            catch (Exception ex) {
                migrationsExist = false;
            }
            if (!migrationsExist) {
                String createTable = "CREATE TABLE " + this.getMigrationsTableName() + " (migration_version INT NOT NULL)";
                statement = connection.prepareStatement(createTable);
                try {
                    statement.execute();
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
                String insertRow = "INSERT INTO " + this.getMigrationsTableName() + " VALUES (?)";
                try (PreparedStatement statement2 = connection.prepareStatement(insertRow);){
                    statement2.setInt(1, -1);
                    statement2.execute();
                }
            }
            String selectVersion = "SELECT migration_version FROM " + this.getMigrationsTableName() + " ORDER BY migration_version DESC LIMIT 1";
            statement = connection.prepareStatement(selectVersion);
            try {
                ResultSet result = statement.executeQuery();
                result.next();
                currentMigration = result.getInt("migration_version");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            int finalCurrentMigration = currentMigration;
            List requiredMigrations = this.migrations.stream().filter(x -> x.getRevision() > finalCurrentMigration).sorted(Comparator.comparingInt(DataMigration::getRevision)).collect(Collectors.toList());
            if (requiredMigrations.isEmpty()) {
                return;
            }
            for (DataMigration dataMigration : requiredMigrations) {
                dataMigration.migrate(connection, this.getTablePrefix());
            }
            currentMigration = requiredMigrations.stream().map(DataMigration::getRevision).max(Integer::compareTo).orElse(-1);
            String updateVersion = "UPDATE " + this.getMigrationsTableName() + " SET migration_version = ?";
            try (PreparedStatement statement3 = connection.prepareStatement(updateVersion);){
                statement3.setInt(1, currentMigration);
                statement3.execute();
            }
        }
        catch (Exception ex) {
            throw new SQLException("Failed to run migrations", ex);
        }
    }

    private String getMigrationsTableName() {
        return this.getTablePrefix() + "migrations";
    }

    public String getTablePrefix() {
        if (this.plugin == null) {
            return "";
        }
        return this.plugin.getDescription().getName().toLowerCase() + "_";
    }

    public ExecutorService getAsyncPool() {
        return this.asyncPool;
    }

    public void save(Data data) {
        this.asyncPool.execute(() -> this.saveSync(data));
    }

    public void save(Data data, String idField, Object idValue) {
        this.asyncPool.execute(() -> this.saveSync(data, idField, idValue));
    }

    public void saveSync(Data data, String idField, Object idValue) {
        this.connectDSL((DSLContext context) -> context.insertInto(DSL.table(this.getTablePrefix() + data.getTableName())).set(data.serialize()).onConflict(DSL.field(idField)).doUpdate().set(data.serialize()).where(DSL.field(idField).eq(idValue)).execute());
    }

    public void saveSync(Data data) {
        this.connectDSL((DSLContext context) -> context.insertInto(DSL.table(this.getTablePrefix() + data.getTableName())).set(data.serialize()).onConflict(data.getId() != -1L ? DSL.field("id") : DSL.field("uuid")).doUpdate().set(data.serialize()).where(data.getId() != -1L ? DSL.field("id").eq(data.getId()) : DSL.field("uuid").eq(data.getUniqueId().toString())).execute());
    }

    public void saveBatch(Collection<Data> dataBatch) {
        this.asyncPool.execute(() -> this.saveBatchSync(dataBatch));
    }

    public void saveBatchSync(Collection<Data> dataBatch) {
        this.connectDSL((DSLContext context) -> {
            ArrayList queries = new ArrayList();
            for (Data data : dataBatch) {
                queries.add(context.insertInto(DSL.table(this.getTablePrefix() + data.getTableName())).set(data.serialize()).onConflict(data.getId() != -1L ? DSL.field("id") : DSL.field("uuid")).doUpdate().set(data.serialize()).where(data.getId() != -1L ? DSL.field("id").eq(data.getId()) : DSL.field("uuid").eq(data.getUniqueId().toString())));
            }
            context.batch(queries).execute();
        });
    }

    public void delete(Data data) {
        this.asyncPool.execute(() -> this.deleteSync(data));
    }

    public void deleteSync(Data data) {
        this.connectDSL((DSLContext context) -> context.delete(DSL.table(this.getTablePrefix() + data.getTableName())).where(data.getId() != -1L ? DSL.field("id").eq(data.getId()) : DSL.field("uuid").eq(data.getUniqueId().toString())).execute());
    }

    public void delete(Data data, String idField, Object idValue) {
        this.asyncPool.execute(() -> this.deleteSync(data, idField, idValue));
    }

    public void deleteSync(Data data, String idField, Object idValue) {
        this.connectDSL((DSLContext context) -> context.delete(DSL.table(this.getTablePrefix() + data.getTableName())).where(DSL.field(idField).eq(idValue)).execute());
    }

    public void delete(Data data, String uuidColumn) {
        this.asyncPool.execute(() -> this.connectDSL((DSLContext context) -> context.delete(DSL.table(this.getTablePrefix() + data.getTableName())).where(data.getId() != -1L ? DSL.field("id").eq(data.getId()) : DSL.field(uuidColumn).eq(data.getUniqueId().toString())).execute()));
    }

    public <T extends Data> T load(int id, Class<?> clazz, String table) {
        try {
            AtomicReference data = new AtomicReference();
            AtomicBoolean found = new AtomicBoolean(false);
            this.connectDSL((DSLContext context) -> {
                try {
                    Data newData = (Data)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    data.set(newData.deserialize(((Record)Objects.requireNonNull(context.select(new SelectFieldOrAsterisk[0]).from((TableLike<?>)DSL.table(this.getTablePrefix() + table)).where(DSL.field("id").eq(id)).fetchOne())).intoMap()));
                    found.set(true);
                }
                catch (NullPointerException newData) {
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            });
            if (found.get()) {
                return (T)((Data)data.get());
            }
            return null;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public <T extends Data> T load(UUID uuid, Class<?> clazz, String table) {
        try {
            AtomicReference data = new AtomicReference();
            AtomicBoolean found = new AtomicBoolean(false);
            this.connectDSL((DSLContext context) -> {
                try {
                    Data newData = (Data)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    data.set(newData.deserialize(((Record)Objects.requireNonNull(context.select(new SelectFieldOrAsterisk[0]).from((TableLike<?>)DSL.table(this.getTablePrefix() + table)).where(DSL.field("uuid").eq(uuid.toString())).fetchOne())).intoMap()));
                    found.set(true);
                }
                catch (NullPointerException newData) {
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            });
            if (found.get()) {
                return (T)((Data)data.get());
            }
            return null;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public <T extends Data> T load(UUID uuid, Class<?> clazz, String table, String uuidColumn) {
        try {
            AtomicReference data = new AtomicReference();
            AtomicBoolean found = new AtomicBoolean(false);
            this.connectDSL((DSLContext context) -> {
                try {
                    Data newData = (Data)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    data.set(newData.deserialize(((Record)Objects.requireNonNull(context.select(new SelectFieldOrAsterisk[0]).from((TableLike<?>)DSL.table(this.getTablePrefix() + table)).where(DSL.field(uuidColumn).eq(uuid.toString())).fetchOne())).intoMap()));
                    found.set(true);
                }
                catch (NullPointerException newData) {
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            });
            if (found.get()) {
                return (T)((Data)data.get());
            }
            return null;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public <T extends Data> List<T> loadBatch(Class<?> clazz, String table) {
        try {
            List dataList = Collections.synchronizedList(new ArrayList());
            this.connectDSL((DSLContext context) -> {
                try {
                    for (Record record : Objects.requireNonNull(context.select(new SelectFieldOrAsterisk[0]).from((TableLike<?>)DSL.table(this.getTablePrefix() + table)).fetchArray())) {
                        Data data = (Data)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        dataList.add(data.deserialize(record.intoMap()));
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            });
            return dataList;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public <T extends Data> List<T> loadBatch(Class<?> clazz, String table, Condition ... conditions) {
        try {
            List dataList = Collections.synchronizedList(new ArrayList());
            this.connectDSL((DSLContext context) -> {
                try {
                    for (Record record : Objects.requireNonNull(context.select(new SelectFieldOrAsterisk[0]).from((TableLike<?>)DSL.table(this.getTablePrefix() + table)).where(conditions).fetchArray())) {
                        Data data = (Data)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        dataList.add(data.deserialize(record.intoMap()));
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            });
            return dataList;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void shutdown() {
        this.asyncPool.shutdown();
        try {
            if (!this.asyncPool.awaitTermination(30L, TimeUnit.SECONDS)) {
                this.plugin.getLogger().warning("Failed to shutdown the async DataManager pool in time. Forcing shutdown");
            }
        }
        catch (InterruptedException ex) {
            this.plugin.getLogger().warning("Error while shutting down the async DataManager pool: " + ex.getMessage());
        }
        this.asyncPool.shutdownNow();
        try {
            this.hikariPool.shutdown();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public List<Runnable> shutdownNow() {
        List<Runnable> tasksLeftInQueue = this.asyncPool.shutdownNow();
        try {
            this.hikariPool.shutdown();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return tasksLeftInQueue;
    }
}

