/*
 * Decompiled with CFR 0.152.
 */
package me.ceze88.vortexcore;

import me.ceze88.vortexcore.VortexCore;
import me.ceze88.vortexcore.database.DataManager;
import me.ceze88.vortexcore.database.DataMigration;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class VortexPlugin
extends JavaPlugin {
    public static final String DOWNLOAD_ID;
    private static VortexPlugin instance;
    private DataManager dataManager;

    public void onEnable() {
        instance = this;
        VortexCore.setPlugin((Plugin)this);
        this.dataManager = new DataManager(this);
        this.getLogger().info(String.valueOf(ChatColor.GREEN) + "===================");
        this.getLogger().info("Enabling " + this.getDescription().getName() + " v" + this.getDescription().getVersion());
        this.onPluginEnable();
        this.getLogger().info("\u00a7aEnabled successfully!");
        this.getLogger().info(String.valueOf(ChatColor.GREEN) + "===================");
    }

    public void onDisable() {
        this.getLogger().info(String.valueOf(ChatColor.RED) + "===================");
        this.getLogger().info("Disabling " + this.getDescription().getName() + " v" + this.getDescription().getVersion());
        Bukkit.getScheduler().cancelTasks((Plugin)this);
        this.onPluginDisable();
        this.getLogger().info("\u00a7cDisabled successfully!");
        this.getLogger().info(String.valueOf(ChatColor.RED) + "===================");
    }

    protected abstract void onPluginEnable();

    protected abstract void onPluginDisable();

    public static VortexPlugin getInstance() {
        return instance;
    }

    public DataManager getDataManager() {
        return this.dataManager;
    }

    protected void initDatabase(DataMigration ... migrations) {
        this.dataManager.init(migrations);
    }

    static {
        System.setProperty("org.jooq.no-tips", "true");
        System.setProperty("org.jooq.no-logo", "true");
        System.setProperty("org.jooq.log.org.jooq.impl.DefaultExecuteContext.logVersionSupport", "ERROR");
        DOWNLOAD_ID = "%%DOWNLOAD_ID%%";
    }
}

