/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.extension.platform.AbstractCommandBlockActor;
import com.sk89q.worldedit.session.SessionKey;
import com.sk89q.worldedit.util.auth.AuthorizationException;
import com.sk89q.worldedit.util.formatting.WorldEditText;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.adapter.bukkit.TextAdapter;
import com.sk89q.worldedit.util.formatting.text.format.TextColor;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class BukkitBlockCommandSender
extends AbstractCommandBlockActor {
    private final BlockCommandSender sender;
    private final WorldEditPlugin plugin;
    private final UUID uuid;

    public BukkitBlockCommandSender(WorldEditPlugin plugin, BlockCommandSender sender) {
        super(BukkitAdapter.adapt(((BlockCommandSender)Preconditions.checkNotNull((Object)sender)).getBlock().getLocation()));
        Preconditions.checkNotNull((Object)((Object)plugin));
        this.plugin = plugin;
        this.sender = sender;
        this.uuid = UUID.nameUUIDFromBytes(("CMD" + sender.getName()).getBytes(StandardCharsets.UTF_8));
    }

    public String getName() {
        return this.sender.getName();
    }

    @Deprecated
    public void printRaw(String msg) {
        for (String part : msg.split("\n")) {
            this.sender.sendMessage(part);
        }
    }

    @Deprecated
    public void print(String msg) {
        for (String part : msg.split("\n")) {
            this.print((Component)TextComponent.of((String)part, (TextColor)TextColor.LIGHT_PURPLE));
        }
    }

    @Deprecated
    public void printDebug(String msg) {
        for (String part : msg.split("\n")) {
            this.print((Component)TextComponent.of((String)part, (TextColor)TextColor.GRAY));
        }
    }

    @Deprecated
    public void printError(String msg) {
        for (String part : msg.split("\n")) {
            this.print((Component)TextComponent.of((String)part, (TextColor)TextColor.RED));
        }
    }

    public void print(Component component) {
        TextAdapter.sendMessage((CommandSender)this.sender, (Component)WorldEditText.format((Component)component, (Locale)this.getLocale()));
    }

    public Locale getLocale() {
        return WorldEdit.getInstance().getConfiguration().defaultLocale;
    }

    public UUID getUniqueId() {
        return this.uuid;
    }

    public String[] getGroups() {
        return new String[0];
    }

    public void checkPermission(String permission) throws AuthorizationException {
        if (!this.hasPermission(permission)) {
            throw new AuthorizationException();
        }
    }

    public boolean hasPermission(String permission) {
        return this.sender.hasPermission(permission);
    }

    public BlockCommandSender getSender() {
        return this.sender;
    }

    public SessionKey getSessionKey() {
        return new SessionKey(){
            private volatile boolean active = true;

            private void updateActive() {
                Block block = BukkitBlockCommandSender.this.sender.getBlock();
                if (!block.getWorld().isChunkLoaded(block.getX() >> 4, block.getZ() >> 4)) {
                    this.active = false;
                    return;
                }
                Material type = block.getType();
                this.active = type == Material.COMMAND_BLOCK || type == Material.CHAIN_COMMAND_BLOCK || type == Material.REPEATING_COMMAND_BLOCK;
            }

            public String getName() {
                return BukkitBlockCommandSender.this.sender.getName();
            }

            public boolean isActive() {
                if (Bukkit.isPrimaryThread()) {
                    this.updateActive();
                } else {
                    Bukkit.getScheduler().callSyncMethod((Plugin)BukkitBlockCommandSender.this.plugin, () -> {
                        this.updateActive();
                        return null;
                    });
                }
                return this.active;
            }

            public boolean isPersistent() {
                return true;
            }

            public UUID getUniqueId() {
                return BukkitBlockCommandSender.this.uuid;
            }
        };
    }
}

