/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.utilities.mythicmobs.conditions;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.queues.ContextSource;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.conditions.ICasterCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.IEntityComparisonCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.IEntityCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.ILocationCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.ISkillMetaCondition;
import java.util.HashMap;
import org.bukkit.World;

public class DenizenCondition
extends SkillCondition
implements IEntityCondition,
ILocationCondition,
ICasterCondition,
ISkillMetaCondition,
IEntityComparisonCondition {
    final String tag;
    ContextSource.SimpleMap source;

    public DenizenCondition(String line, MythicLineConfig mlc) {
        super(line);
        this.tag = mlc.getString("tag");
        this.source = new ContextSource.SimpleMap();
        this.source.contexts = new HashMap();
    }

    public boolean check(AbstractEntity entity) {
        this.source.contexts.put("target", new EntityTag(entity.getBukkitEntity()));
        return this.runCheck();
    }

    public boolean check(AbstractLocation location) {
        this.source.contexts.put("location", new LocationTag((World)location.getWorld(), location.getX(), location.getY(), location.getZ()));
        return this.runCheck();
    }

    public boolean check(SkillCaster caster) {
        this.source.contexts.put("entity", new EntityTag(caster.getEntity().getBukkitEntity()));
        if (caster.getEntity().getTarget() == null) {
            this.source.contexts.put("target", new EntityTag(caster.getEntity().getTarget().getBukkitEntity()));
        }
        return this.runCheck();
    }

    public boolean check(SkillMetadata skillMetadata) {
        this.source.contexts.put("entity", new EntityTag(skillMetadata.getCaster().getEntity().getBukkitEntity()));
        this.source.contexts.put("target", new EntityTag(skillMetadata.getCaster().getEntity().getTarget().getBukkitEntity()));
        if (skillMetadata.getTrigger() == null) {
            this.source.contexts.put("trigger", new EntityTag(skillMetadata.getTrigger().getBukkitEntity()));
        }
        return this.runCheck();
    }

    public boolean check(AbstractEntity entity1, AbstractEntity entity2) {
        this.source.contexts.put("entity", new EntityTag(entity1.getBukkitEntity()));
        this.source.contexts.put("target", new EntityTag(entity2.getBukkitEntity()));
        return this.runCheck();
    }

    public boolean runCheck() {
        TagContext tagContext = CoreUtilities.noDebugContext.clone();
        tagContext.contextSource = this.source;
        ObjectTag object = TagManager.tagObject((String)this.tag, (TagContext)tagContext);
        return ((ElementTag)object.asType(ElementTag.class, tagContext)).asBoolean();
    }
}

