/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.properties.worldguard;

import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.depenizen.bukkit.objects.worldguard.WorldGuardRegionTag;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import org.bukkit.Location;
import org.bukkit.World;

public class WorldGuardLocationProperties
implements Property {
    public static final String[] handledTags = new String[]{"in_region", "regions"};
    public static final String[] handledMechs = new String[0];
    LocationTag location;

    public String getPropertyString() {
        return null;
    }

    public String getPropertyId() {
        return "WorldGuardLocation";
    }

    public void adjust(Mechanism mechanism) {
    }

    public static boolean describes(ObjectTag loc) {
        return loc instanceof LocationTag;
    }

    public static WorldGuardLocationProperties getFrom(ObjectTag loc) {
        if (!WorldGuardLocationProperties.describes(loc)) {
            return null;
        }
        return new WorldGuardLocationProperties((LocationTag)loc);
    }

    private WorldGuardLocationProperties(LocationTag loc) {
        this.location = loc;
    }

    private ApplicableRegionSet getApplicableRegions() {
        return WorldGuard.getInstance().getPlatform().getRegionContainer().get(BukkitAdapter.adapt((World)this.location.getWorld())).getApplicableRegions(BukkitAdapter.asBlockVector((Location)this.location));
    }

    private boolean inRegion() {
        return this.getApplicableRegions().size() > 0;
    }

    private boolean inRegion(String region) {
        for (ProtectedRegion protectedRegion : this.getApplicableRegions()) {
            if (!protectedRegion.getId().equalsIgnoreCase(region)) continue;
            return true;
        }
        return false;
    }

    private ListTag getRegions(World world) {
        ListTag regionList = new ListTag();
        for (ProtectedRegion protectedRegion : this.getApplicableRegions()) {
            regionList.addObject((ObjectTag)new WorldGuardRegionTag(protectedRegion, world));
        }
        return regionList;
    }

    public String getAttribute(Attribute attribute) {
        if (attribute.startsWith("in_region")) {
            if (attribute.hasContext(1)) {
                ListTag region_list = (ListTag)attribute.contextAsType(1, ListTag.class);
                for (String region : region_list) {
                    if (!this.inRegion(region)) continue;
                    return new ElementTag(true).getAttribute(attribute.fulfill(1));
                }
                return new ElementTag(false).getAttribute(attribute.fulfill(1));
            }
            return new ElementTag(this.inRegion()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("regions")) {
            return this.getRegions(this.location.getWorld()).getAttribute(attribute.fulfill(1));
        }
        return null;
    }
}

