/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.properties.towny;

import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.depenizen.bukkit.objects.towny.TownTag;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.TownBlock;
import java.util.UUID;
import org.bukkit.Location;

public class TownyLocationProperties
implements Property {
    public static final String[] handledTags = new String[]{"has_town", "town", "is_wilderness", "towny"};
    public static final String[] handledMechs = new String[0];
    public LocationTag location;

    public String getPropertyString() {
        return null;
    }

    public String getPropertyId() {
        return "TownyLocation";
    }

    public void adjust(Mechanism mechanism) {
    }

    public static boolean describes(ObjectTag object) {
        return object instanceof LocationTag;
    }

    public static TownyLocationProperties getFrom(ObjectTag object) {
        if (!TownyLocationProperties.describes(object)) {
            return null;
        }
        return new TownyLocationProperties((LocationTag)object);
    }

    private TownyLocationProperties(LocationTag location) {
        this.location = location;
    }

    public String getAttribute(Attribute attribute) {
        TownBlock block;
        block13: {
            if (attribute.startsWith("towny")) {
                attribute = attribute.fulfill(1);
                try {
                    block = TownyAPI.getInstance().getTownBlock((Location)this.location);
                    if (block == null) {
                        return null;
                    }
                    if (attribute.startsWith("resident")) {
                        if (!block.hasResident()) {
                            return null;
                        }
                        UUID player = (UUID)PlayerTag.getAllPlayers().get(block.getResident().getName());
                        return new PlayerTag(player).getAttribute(attribute.fulfill(1));
                    }
                }
                catch (NotRegisteredException ex) {
                    if (attribute.hasAlternative()) break block13;
                    Debug.echoError((String)("Towny tag NotRegisteredException: " + ex.getMessage()));
                }
            }
        }
        if (attribute.startsWith("towny_type")) {
            block = TownyAPI.getInstance().getTownBlock((Location)this.location);
            if (block != null) {
                return new ElementTag(block.getType().name()).getAttribute(attribute.fulfill(1));
            }
            return null;
        }
        if (attribute.startsWith("has_town")) {
            if (TownyAPI.getInstance().getTownName((Location)this.location) != null) {
                return new ElementTag(true).getAttribute(attribute.fulfill(1));
            }
            return new ElementTag(false).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("town")) {
            String town = TownyAPI.getInstance().getTownName((Location)this.location);
            if (town == null) {
                return null;
            }
            return new TownTag(TownyUniverse.getInstance().getTown(town)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_wilderness")) {
            return new ElementTag(TownyAPI.getInstance().isWilderness(this.location.getBlock())).getAttribute(attribute.fulfill(1));
        }
        return null;
    }
}

