/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.properties.sentinel;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;
import org.mcmonkey.sentinel.SentinelTrait;
import org.mcmonkey.sentinel.commands.SentinelCommand;
import org.mcmonkey.sentinel.targeting.SentinelTargetList;

public class SentinelNPCProperties
implements Property {
    public static final String[] handledTags = new String[]{"sentinel"};
    public static final String[] handledMechs = new String[0];
    NPCTag npc;

    public String getPropertyString() {
        return null;
    }

    public String getPropertyId() {
        return "SentinelNPC";
    }

    public static boolean describes(ObjectTag object) {
        return object instanceof NPCTag;
    }

    public static SentinelNPCProperties getFrom(ObjectTag object) {
        if (!SentinelNPCProperties.describes(object)) {
            return null;
        }
        return new SentinelNPCProperties((NPCTag)object);
    }

    private SentinelNPCProperties(NPCTag npc) {
        this.npc = npc;
    }

    public static ListTag listTargets(SentinelTargetList list) {
        String comboStr = list.toComboString().replace(SentinelCommand.colorBasic, "").replace(ChatColor.AQUA.toString(), "").trim();
        ListTag result = new ListTag();
        if (comboStr.isEmpty()) {
            return result;
        }
        for (String target : CoreUtilities.split((String)comboStr, (char)'\u0001')) {
            result.add(target.trim());
        }
        return result;
    }

    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("sentinel")) {
            attribute = attribute.fulfill(1);
            if (!this.npc.getCitizen().hasTrait(SentinelTrait.class)) {
                return null;
            }
            SentinelTrait sentinel = (SentinelTrait)this.npc.getCitizen().getOrAddTrait(SentinelTrait.class);
            if (attribute.startsWith("chasing")) {
                if (sentinel.chasing == null) {
                    return null;
                }
                return new EntityTag((Entity)sentinel.chasing).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("targets")) {
                return SentinelNPCProperties.listTargets(sentinel.allTargets).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("ignores")) {
                return SentinelNPCProperties.listTargets(sentinel.allIgnores).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("avoids")) {
                return SentinelNPCProperties.listTargets(sentinel.allAvoids).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("avoid_range")) {
                return new ElementTag(sentinel.avoidRange).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("range")) {
                return new ElementTag(sentinel.range).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("raw_damage")) {
                return new ElementTag(sentinel.damage).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("damage")) {
                return new ElementTag(sentinel.getDamage()).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("raw_armor")) {
                return new ElementTag(sentinel.armor).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("armor")) {
                return new ElementTag(sentinel.getArmor(sentinel.getLivingEntity())).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("health")) {
                return new ElementTag(sentinel.health).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("ranged_chase")) {
                return new ElementTag(sentinel.rangedChase).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("close_chase")) {
                return new ElementTag(sentinel.closeChase).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("invincible")) {
                return new ElementTag(sentinel.invincible).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("fightback")) {
                return new ElementTag(sentinel.fightback).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("runaway")) {
                return new ElementTag(sentinel.runaway).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("attack_rate")) {
                return new DurationTag((long)sentinel.attackRate).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("attack_rate")) {
                return new DurationTag((long)sentinel.attackRateRanged).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("heal_rate")) {
                return new DurationTag((long)sentinel.healRate).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("guarding")) {
                LivingEntity entity = sentinel.getGuardingEntity();
                if (entity == null) {
                    return null;
                }
                return new EntityTag((Entity)entity).getDenizenObject().getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("needs_ammo")) {
                return new ElementTag(sentinel.needsAmmo).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("safe_shot")) {
                return new ElementTag(sentinel.safeShot).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("respawn_time")) {
                return new DurationTag(sentinel.respawnTime).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("chase_range")) {
                return new ElementTag(sentinel.chaseRange).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("spawn_point")) {
                if (sentinel.spawnPoint == null) {
                    return null;
                }
                return new LocationTag(sentinel.spawnPoint).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("avoid_return_point")) {
                if (sentinel.avoidReturnPoint == null) {
                    return null;
                }
                return new LocationTag(sentinel.avoidReturnPoint).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("drops")) {
                ListTag drops = new ListTag();
                for (ItemStack item : sentinel.drops) {
                    drops.addObject((ObjectTag)new ItemTag(item.clone()));
                }
                return drops.getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("drop_chances")) {
                ListTag drops = new ListTag();
                for (Double chance : sentinel.dropChances) {
                    drops.add(chance.toString());
                }
                return drops.getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("enemy_drops")) {
                return new ElementTag(sentinel.enemyDrops).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("enemy_target_time")) {
                return new DurationTag(sentinel.enemyTargetTime).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("speed")) {
                return new ElementTag(sentinel.speed).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("warning")) {
                return new ElementTag(sentinel.warningText).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("greeting")) {
                return new ElementTag(sentinel.greetingText).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("greet_range")) {
                return new ElementTag(sentinel.greetRange).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("greet_rate")) {
                return new DurationTag((long)sentinel.greetRate).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("autoswitch")) {
                return new ElementTag(sentinel.autoswitch).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("squad")) {
                if (sentinel.squad == null) {
                    return null;
                }
                return new ElementTag(sentinel.squad).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("accuracy")) {
                return new ElementTag(sentinel.accuracy).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("realistic")) {
                return new ElementTag(sentinel.realistic).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("reach")) {
                return new ElementTag(sentinel.reach).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("guard_distance_minimum")) {
                return new ElementTag(sentinel.guardDistanceMinimum).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("guard_selection_range")) {
                return new ElementTag(sentinel.guardSelectionRange).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("weapon_damage")) {
                ListTag result = new ListTag();
                for (Map.Entry damage : sentinel.weaponDamage.entrySet()) {
                    result.add((String)damage.getKey() + "/" + damage.getValue());
                }
                return result.getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("weapon_redirects")) {
                ListTag result = new ListTag();
                for (Map.Entry redir : sentinel.weaponRedirects.entrySet()) {
                    result.add((String)redir.getKey() + "/" + (String)redir.getValue());
                }
                return result.getAttribute(attribute.fulfill(1));
            }
        }
        return null;
    }

    public void adjust(Mechanism mechanism) {
    }
}

