/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.properties.quests;

import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.depenizen.bukkit.bridges.QuestsBridge;
import java.util.Set;
import me.blackvein.quests.Quest;
import me.blackvein.quests.Quester;
import me.blackvein.quests.Quests;

public class QuestsPlayerProperties
implements Property {
    public static final String[] handledTags = new String[]{"quests"};
    public static final String[] handledMechs = new String[0];
    PlayerTag player;
    Quester quester;

    public String getPropertyString() {
        return null;
    }

    public String getPropertyId() {
        return "QuestsPlayer";
    }

    public static boolean describes(ObjectTag object) {
        return object instanceof PlayerTag;
    }

    public static QuestsPlayerProperties getFrom(ObjectTag object) {
        if (!QuestsPlayerProperties.describes(object)) {
            return null;
        }
        return new QuestsPlayerProperties((PlayerTag)object);
    }

    private QuestsPlayerProperties(PlayerTag player) {
        this.player = player;
        Quests quests = (Quests)QuestsBridge.instance.plugin;
        this.quester = quests.getQuester(player.getUUID());
    }

    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("quests")) {
            if ((attribute = attribute.fulfill(1)).startsWith("points")) {
                if (this.quester.getBaseData().contains("quest-points")) {
                    return new ElementTag(this.quester.getBaseData().getInt("quest-points")).getAttribute(attribute.fulfill(1));
                }
                return new ElementTag("0").getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("completed_names")) {
                ListTag list = new ListTag((Set)this.quester.getCompletedQuests());
                return list.getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("active_names")) {
                ListTag list = new ListTag();
                for (Quest quest : this.quester.getCurrentQuests().keySet()) {
                    list.add(quest.getName());
                }
                return list.getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("completed")) {
                return new ElementTag(this.quester.getCompletedQuests().size()).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("active")) {
                return new ElementTag(this.quester.getCurrentQuests().size()).getAttribute(attribute.fulfill(1));
            }
            return null;
        }
        return null;
    }

    public void adjust(Mechanism mechanism) {
    }
}

