/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.properties.griefprevention;

import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.depenizen.bukkit.objects.griefprevention.GriefPreventionClaimTag;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.DataStore;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import me.ryanhamshire.GriefPrevention.PlayerData;

public class GriefPreventionPlayerProperties
implements Property {
    static DataStore dataStore = GriefPrevention.instance.dataStore;
    public static final String[] handledTags = new String[]{"griefprevention"};
    public static final String[] handledMechs = new String[]{"bonus_blocks", "normal_blocks"};
    PlayerData data;
    PlayerTag player;

    public String getPropertyString() {
        return null;
    }

    public String getPropertyId() {
        return "GriefPreventionPlayer";
    }

    public static boolean describes(ObjectTag object) {
        return object instanceof PlayerTag;
    }

    public static GriefPreventionPlayerProperties getFrom(ObjectTag object) {
        if (!GriefPreventionPlayerProperties.describes(object)) {
            return null;
        }
        return new GriefPreventionPlayerProperties((PlayerTag)object);
    }

    private GriefPreventionPlayerProperties(PlayerTag player) {
        this.player = player;
        this.data = dataStore.getPlayerData(player.getUUID());
    }

    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("grief_prevention") || attribute.startsWith("gp") || attribute.startsWith("griefprevention")) {
            if ((attribute = attribute.fulfill(1)).startsWith("list_claims")) {
                ListTag claims = new ListTag();
                for (Claim claim : this.data.getClaims()) {
                    claims.addObject((ObjectTag)new GriefPreventionClaimTag(claim));
                }
                return claims.getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("claims")) {
                return new ElementTag(this.data.getClaims().size()).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("blocks")) {
                if ((attribute = attribute.fulfill(1)).startsWith("remaining")) {
                    return new ElementTag(this.data.getRemainingClaimBlocks()).getAttribute(attribute.fulfill(1));
                }
                if (attribute.startsWith("bonus")) {
                    return new ElementTag(this.data.getBonusClaimBlocks()).getAttribute(attribute.fulfill(1));
                }
                if (attribute.startsWith("total")) {
                    return new ElementTag(this.data.getAccruedClaimBlocks() + this.data.getBonusClaimBlocks()).getAttribute(attribute.fulfill(1));
                }
                return new ElementTag(this.data.getAccruedClaimBlocks()).getAttribute(attribute);
            }
        }
        return null;
    }

    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("bonus_blocks") && mechanism.requireInteger()) {
            this.data.setBonusClaimBlocks(Integer.valueOf(mechanism.getValue().asInt()));
        }
        if (mechanism.matches("normal_blocks") && mechanism.requireInteger()) {
            this.data.setAccruedClaimBlocks(Integer.valueOf(mechanism.getValue().asInt()));
        }
    }
}

