/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.properties.essentials;

import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.debugging.SlowWarning;
import com.denizenscript.depenizen.bukkit.bridges.EssentialsBridge;
import com.earth2me.essentials.Essentials;
import com.earth2me.essentials.IUser;
import com.earth2me.essentials.User;

public class EssentialsPlayerProperties
implements Property {
    public static final String[] handledTags = new String[]{"god_mode", "has_home", "is_afk", "is_muted", "is_vanished", "home_list", "home_location_list", "ignored_players", "home_name_list", "mail_list", "mute_timout", "socialspy", "list_home_locations", "list_home_names", "list_homes", "list_mails", "essentials_homes"};
    public static final String[] handledMechs = new String[]{"is_afk", "god_mode", "is_muted", "socialspy", "vanish", "essentials_ignore"};
    public static SlowWarning oldHomesTag = new SlowWarning("The tag 'list_homes' from Depenizen/Essentials is deprecated: use 'essentials_homes' (now a MapTag).");
    PlayerTag player;

    public String getPropertyString() {
        return null;
    }

    public String getPropertyId() {
        return "EssentialsPlayer";
    }

    public static boolean describes(ObjectTag object) {
        return object instanceof PlayerTag && ((PlayerTag)object).isOnline();
    }

    public static EssentialsPlayerProperties getFrom(ObjectTag object) {
        if (!EssentialsPlayerProperties.describes(object)) {
            return null;
        }
        return new EssentialsPlayerProperties((PlayerTag)object);
    }

    private EssentialsPlayerProperties(PlayerTag player) {
        this.player = player;
    }

    public User getUser() {
        return ((Essentials)EssentialsBridge.instance.plugin).getUser(this.player.getUUID());
    }

    public String getAttribute(Attribute attribute) {
        if (attribute.startsWith("god_mode")) {
            return new ElementTag(this.getUser().isGodModeEnabled()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("has_home")) {
            return new ElementTag(this.getUser().hasHome()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_afk")) {
            return new ElementTag(this.getUser().isAfk()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_muted")) {
            return new ElementTag(this.getUser().isMuted()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_vanished")) {
            return new ElementTag(this.getUser().isVanished()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("essentials_homes")) {
            MapTag homes = new MapTag();
            for (String home : this.getUser().getHomes()) {
                try {
                    homes.putObject(home, (ObjectTag)new LocationTag(this.getUser().getHome(home)));
                }
                catch (Exception e) {
                    if (attribute.hasAlternative()) continue;
                    Debug.echoError((Throwable)e);
                }
            }
            return homes.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("list_homes") || attribute.startsWith("home_list")) {
            oldHomesTag.warn(attribute.context);
            ListTag homes = new ListTag();
            for (String home : this.getUser().getHomes()) {
                try {
                    homes.add(home + "/" + new LocationTag(this.getUser().getHome(home)).identifySimple());
                }
                catch (Exception e) {
                    if (attribute.hasAlternative()) continue;
                    Debug.echoError((Throwable)e);
                }
            }
            return homes.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("list_home_locations") || attribute.startsWith("home_location_list")) {
            oldHomesTag.warn(attribute.context);
            ListTag homes = new ListTag();
            for (String home : this.getUser().getHomes()) {
                try {
                    homes.addObject((ObjectTag)new LocationTag(this.getUser().getHome(home)));
                }
                catch (Exception e) {
                    if (attribute.hasAlternative()) continue;
                    Debug.echoError((Throwable)e);
                }
            }
            return homes.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("list_home_names") || attribute.startsWith("home_name_list")) {
            oldHomesTag.warn(attribute.context);
            return new ListTag(this.getUser().getHomes()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("ignored_players")) {
            ListTag players = new ListTag();
            Essentials ess = (Essentials)EssentialsBridge.instance.plugin;
            for (String player : this.getUser()._getIgnoredPlayers()) {
                try {
                    players.addObject((ObjectTag)new PlayerTag(ess.getOfflineUser(player).getBase()));
                }
                catch (Exception e) {
                    if (attribute.hasAlternative()) continue;
                    Debug.echoError((Throwable)e);
                }
            }
            return players.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("list_mails") || attribute.startsWith("mail_list")) {
            return new ListTag(this.getUser().getMails()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("mute_timeout")) {
            return new DurationTag(this.getUser().getMuteTimeout() - System.currentTimeMillis()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("socialspy")) {
            return new ElementTag(this.getUser().isSocialSpyEnabled()).getAttribute(attribute.fulfill(1));
        }
        return null;
    }

    public void adjust(Mechanism mechanism) {
        if ((mechanism.matches("is_afk") || mechanism.matches("afk")) && mechanism.requireBoolean()) {
            this.getUser().setAfk(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("god_mode") && mechanism.requireBoolean()) {
            this.getUser().setGodModeEnabled(mechanism.getValue().asBoolean());
        }
        if ((mechanism.matches("is_muted") || mechanism.matches("muted")) && mechanism.requireBoolean()) {
            ListTag split = (ListTag)mechanism.valueAsType(ListTag.class);
            this.getUser().setMuted(new ElementTag(split.get(0)).asBoolean());
            if (split.size() > 1) {
                this.getUser().setMuteTimeout(System.currentTimeMillis() + DurationTag.valueOf((String)split.get(1), (TagContext)mechanism.context).getMillis());
            }
        }
        if (mechanism.matches("socialspy") && mechanism.requireBoolean()) {
            this.getUser().setSocialSpyEnabled(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("vanish") && mechanism.requireBoolean()) {
            this.getUser().setVanished(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("essentials_ignore")) {
            Essentials ess = (Essentials)EssentialsBridge.instance.plugin;
            ListTag split = (ListTag)mechanism.valueAsType(ListTag.class);
            PlayerTag otherPlayer = PlayerTag.valueOf((String)split.get(0), (TagContext)mechanism.context);
            boolean shouldIgnore = split.size() < 2 || new ElementTag(split.get(1)).asBoolean();
            this.getUser().setIgnoredPlayer((IUser)ess.getUser(otherPlayer.getUUID()), shouldIgnore);
        }
    }
}

