/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.properties.essentials;

import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.depenizen.bukkit.bridges.EssentialsBridge;
import com.earth2me.essentials.Essentials;
import com.earth2me.essentials.IEssentials;
import java.math.BigDecimal;

public class EssentialsItemProperties
implements Property {
    public static final String[] handledTags = new String[]{"worth"};
    public static final String[] handledMechs = new String[]{"worth"};
    ItemTag item;

    public String getPropertyString() {
        return null;
    }

    public String getPropertyId() {
        return "EssentialsItem";
    }

    public static boolean describes(ObjectTag object) {
        return object instanceof ItemTag;
    }

    public static EssentialsItemProperties getFrom(ObjectTag object) {
        if (!EssentialsItemProperties.describes(object)) {
            return null;
        }
        return new EssentialsItemProperties((ItemTag)object);
    }

    private EssentialsItemProperties(ItemTag item) {
        this.item = item;
    }

    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("worth")) {
            Essentials ess = (Essentials)EssentialsBridge.instance.plugin;
            BigDecimal priceBD = ess.getWorth().getPrice((IEssentials)ess, this.item.getItemStack());
            if (priceBD == null) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError((String)("Item does not have a worth value: " + this.item.identify()));
                }
                return null;
            }
            if ((attribute = attribute.fulfill(1)).startsWith("quantity") && attribute.hasContext(1)) {
                return new ElementTag(priceBD.multiply(BigDecimal.valueOf(attribute.getIntContext(1)))).getAttribute(attribute.fulfill(1));
            }
            return new ElementTag(priceBD).getAttribute(attribute);
        }
        return null;
    }

    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("worth") && mechanism.requireDouble()) {
            Essentials ess = (Essentials)EssentialsBridge.instance.plugin;
            ess.getWorth().setPrice((IEssentials)ess, this.item.getItemStack(), mechanism.getValue().asDouble());
        }
    }
}

