/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.objects.worldguard;

import com.denizenscript.denizen.objects.CuboidTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.objects.PolygonTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.debugging.SlowWarning;
import com.denizenscript.denizencore.utilities.debugging.Warning;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedCuboidRegion;
import com.sk89q.worldguard.protection.regions.ProtectedPolygonalRegion;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;

public class WorldGuardRegionTag
implements ObjectTag {
    static final Pattern regionPattern = Pattern.compile("(?:region@)?(.+),(.+)", 2);
    ProtectedRegion region;
    World world;
    private String prefix = "Region";
    public static Warning oldCuboidTag = new SlowWarning("The tag 'WorldGuardRegionTag.cuboid' is deprecated in favor of the '.area' equivalent.");

    public static WorldGuardRegionTag valueOf(String string) {
        return WorldGuardRegionTag.valueOf(string, null);
    }

    @Fetchable(value="region")
    public static WorldGuardRegionTag valueOf(String string, TagContext context) {
        if (string == null) {
            return null;
        }
        Matcher m = regionPattern.matcher(string);
        if (m.matches()) {
            String regionName = m.group(1);
            String worldName = m.group(2);
            World world = Bukkit.getWorld((String)worldName);
            if (world == null) {
                Debug.echoError((String)("valueOf WorldGuard region returning null: Invalid world '" + worldName + "'"));
                return null;
            }
            RegionManager manager = WorldGuard.getInstance().getPlatform().getRegionContainer().get(BukkitAdapter.adapt((World)world));
            if (!manager.hasRegion(regionName)) {
                Debug.echoError((String)("valueOf WorldGuard region returning null: Invalid region '" + regionName + "' for world '" + worldName + "'"));
                return null;
            }
            return new WorldGuardRegionTag(manager.getRegion(regionName), world);
        }
        return null;
    }

    public static boolean matches(String arg) {
        return regionPattern.matcher(arg).matches();
    }

    public WorldGuardRegionTag(ProtectedRegion region, World world) {
        this.region = region;
        this.world = world;
    }

    public ProtectedRegion getRegion() {
        return this.region;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public ObjectTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public String debug() {
        return this.prefix + "='<A>" + this.identify() + "<G>' ";
    }

    public boolean isUnique() {
        return true;
    }

    public String getObjectType() {
        return "WorldGuardRegion";
    }

    public String identify() {
        return "region@" + this.region.getId() + "," + this.world.getName();
    }

    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    public String getAttribute(Attribute attribute) {
        if (attribute.startsWith("area")) {
            try {
                if (this.region instanceof ProtectedPolygonalRegion) {
                    ProtectedPolygonalRegion polyRegion = (ProtectedPolygonalRegion)this.region;
                    PolygonTag poly = new PolygonTag(new WorldTag(this.world));
                    for (BlockVector2 vec2 : polyRegion.getPoints()) {
                        poly.corners.add(new PolygonTag.Corner((double)vec2.getX(), (double)vec2.getZ()));
                    }
                    poly.yMin = polyRegion.getMinimumPoint().getY();
                    poly.yMax = polyRegion.getMaximumPoint().getY();
                    poly.recalculateBox();
                    return poly.getAttribute(attribute.fulfill(1));
                }
                return new CuboidTag(BukkitAdapter.adapt((World)this.world, (BlockVector3)this.region.getMinimumPoint()), BukkitAdapter.adapt((World)this.world, (BlockVector3)this.region.getMaximumPoint())).getAttribute(attribute.fulfill(1));
            }
            catch (Throwable ex) {
                Debug.echoError((Throwable)ex);
            }
        }
        if (attribute.startsWith("cuboid")) {
            oldCuboidTag.warn(attribute.context);
            if (!(this.region instanceof ProtectedCuboidRegion)) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError((String)"<WorldGuardRegionTag.cuboid> requires a Cuboid-shaped region!");
                }
                return null;
            }
            return new CuboidTag(BukkitAdapter.adapt((World)this.world, (BlockVector3)this.region.getMinimumPoint()), BukkitAdapter.adapt((World)this.world, (BlockVector3)this.region.getMaximumPoint())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("id")) {
            return new ElementTag(this.region.getId()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("members")) {
            ListTag list = new ListTag();
            for (UUID uuid : this.region.getMembers().getUniqueIds()) {
                list.addObject((ObjectTag)PlayerTag.mirrorBukkitPlayer((OfflinePlayer)Bukkit.getOfflinePlayer((UUID)uuid)));
            }
            return list.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("owners")) {
            ListTag list = new ListTag();
            for (UUID uuid : this.region.getOwners().getUniqueIds()) {
                list.addObject((ObjectTag)PlayerTag.mirrorBukkitPlayer((OfflinePlayer)Bukkit.getOfflinePlayer((UUID)uuid)));
            }
            return list.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("world")) {
            return new WorldTag(this.world).getAttribute(attribute.fulfill(1));
        }
        return new ElementTag(this.identify()).getAttribute(attribute);
    }
}

