/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.objects.towny;

import com.denizenscript.denizen.objects.ChunkTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.depenizen.bukkit.objects.factions.NationTag;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.exceptions.EconomyException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.PlotGroup;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.WorldCoord;
import org.bukkit.Location;

public class TownTag
implements ObjectTag,
Adjustable {
    Town town;
    private String prefix = "Town";

    public static TownTag valueOf(String string) {
        return TownTag.valueOf(string, null);
    }

    @Fetchable(value="town")
    public static TownTag valueOf(String string, TagContext context) {
        if (string == null) {
            return null;
        }
        string = string.replace("town@", "");
        Town town = TownyUniverse.getInstance().getTown(string);
        if (town == null) {
            return null;
        }
        return new TownTag(town);
    }

    public static boolean matches(String arg) {
        arg = arg.replace("town@", "");
        return TownyUniverse.getInstance().hasTown(arg);
    }

    public TownTag(Town town) {
        this.town = town;
    }

    public static TownTag fromWorldCoord(WorldCoord coord) {
        if (coord == null) {
            return null;
        }
        try {
            return new TownTag(coord.getTownBlock().getTown());
        }
        catch (NotRegisteredException e) {
            return null;
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    public TownTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public String debug() {
        return this.prefix + "='<A>" + this.identify() + "<G>' ";
    }

    public boolean isUnique() {
        return true;
    }

    public String getObjectType() {
        return "Town";
    }

    public String identify() {
        return "town@" + this.town.getName();
    }

    public String identifySimple() {
        return this.identify();
    }

    public Town getTown() {
        return this.town;
    }

    public boolean equals(TownTag town) {
        return CoreUtilities.equalsIgnoreCase((String)town.getTown().getName(), (String)this.getTown().getName());
    }

    public String toString() {
        return this.identify();
    }

    public String getAttribute(Attribute attribute) {
        if (attribute.startsWith("assistants")) {
            ListTag list = new ListTag();
            for (Resident resident : this.town.getAssistants()) {
                PlayerTag player = PlayerTag.valueOf((String)resident.getName(), (TagContext)attribute.context);
                if (player != null) {
                    list.addObject((ObjectTag)player);
                    continue;
                }
                list.add(resident.getName());
            }
            return list.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("balance")) {
            try {
                return new ElementTag(this.town.getAccount().getHoldingBalance()).getAttribute(attribute.fulfill(1));
            }
            catch (EconomyException e) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError((String)"Invalid economy response!");
                }
            }
        } else {
            if (attribute.startsWith("board")) {
                return new ElementTag(this.town.getTownBoard()).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("isopen") || attribute.startsWith("is_open")) {
                return new ElementTag(this.town.isOpen()).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("ispublic") || attribute.startsWith("is_public")) {
                return new ElementTag(this.town.isPublic()).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("mayor")) {
                return PlayerTag.valueOf((String)this.town.getMayor().getName(), (TagContext)attribute.context).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("name")) {
                return new ElementTag(this.town.getName()).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("nation")) {
                try {
                    return new NationTag(this.town.getNation()).getAttribute(attribute.fulfill(1));
                }
                catch (NotRegisteredException e) {
                }
            } else {
                if (attribute.startsWith("playercount") || attribute.startsWith("player_count")) {
                    return new ElementTag(this.town.getNumResidents()).getAttribute(attribute.fulfill(1));
                }
                if (attribute.startsWith("residents")) {
                    ListTag list = new ListTag();
                    for (Resident resident : this.town.getResidents()) {
                        PlayerTag player = PlayerTag.valueOf((String)resident.getName(), (TagContext)attribute.context);
                        if (player != null) {
                            list.addObject((ObjectTag)player);
                            continue;
                        }
                        list.add(resident.getName());
                    }
                    return list.getAttribute(attribute.fulfill(1));
                }
                if (attribute.startsWith("size")) {
                    return new ElementTag(this.town.getPurchasedBlocks()).getAttribute(attribute.fulfill(1));
                }
                if (attribute.startsWith("spawn")) {
                    try {
                        return new LocationTag(this.town.getSpawn()).getBlockLocation().getAttribute(attribute.fulfill(1));
                    }
                    catch (TownyException list) {
                    }
                } else {
                    if (attribute.startsWith("tag")) {
                        return new ElementTag(this.town.getTag()).getAttribute(attribute.fulfill(1));
                    }
                    if (attribute.startsWith("taxes")) {
                        return new ElementTag(this.town.getTaxes()).getAttribute(attribute.fulfill(1));
                    }
                    if (attribute.startsWith("outposts")) {
                        ListTag posts = new ListTag();
                        for (Location p : this.town.getAllOutpostSpawns()) {
                            posts.addObject((ObjectTag)new LocationTag(p));
                        }
                        return posts.getAttribute(attribute.fulfill(1));
                    }
                    if (attribute.startsWith("has_explosions")) {
                        return new ElementTag(this.town.isBANG()).getAttribute(attribute.fulfill(1));
                    }
                    if (attribute.startsWith("has_mobs")) {
                        return new ElementTag(this.town.hasMobs()).getAttribute(attribute.fulfill(1));
                    }
                    if (attribute.startsWith("has_pvp")) {
                        return new ElementTag(this.town.isPVP()).getAttribute(attribute.fulfill(1));
                    }
                    if (attribute.startsWith("has_firespread")) {
                        return new ElementTag(this.town.isFire()).getAttribute(attribute.fulfill(1));
                    }
                    if (attribute.startsWith("has_taxpercent")) {
                        return new ElementTag(this.town.isTaxPercentage()).getAttribute(attribute.fulfill(1));
                    }
                    if (attribute.startsWith("plot_object_group_names")) {
                        ListTag output = new ListTag();
                        if (!this.town.hasPlotGroups()) {
                            return null;
                        }
                        for (PlotGroup group : this.town.getPlotObjectGroups()) {
                            output.add(group.getName());
                        }
                        return output.getAttribute(attribute.fulfill(1));
                    }
                    if (attribute.startsWith("plots")) {
                        ListTag output = new ListTag();
                        for (TownBlock block : this.town.getTownBlocks()) {
                            output.addObject((ObjectTag)new ChunkTag(new WorldTag(block.getWorld().getName()), block.getX(), block.getZ()));
                        }
                        return output.getAttribute(attribute.fulfill(1));
                    }
                    if (attribute.startsWith("plottax")) {
                        return new ElementTag(this.town.getPlotTax()).getAttribute(attribute.fulfill(1));
                    }
                    if (attribute.startsWith("plotprice")) {
                        return new ElementTag(this.town.getPlotPrice()).getAttribute(attribute.fulfill(1));
                    }
                }
            }
        }
        return new ElementTag(this.identify()).getAttribute(attribute);
    }

    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("balance")) {
            ListTag input = (ListTag)mechanism.valueAsType(ListTag.class);
            if (input.size() != 2 || !ArgumentHelper.matchesDouble((String)input.get(0))) {
                mechanism.echoError("Invalid balance mech input.");
                return;
            }
            try {
                this.town.getAccount().setBalance(new ElementTag(input.get(0)).asDouble(), input.get(1));
            }
            catch (EconomyException ex) {
                Debug.echoError((Throwable)ex);
            }
        }
    }

    public void applyProperty(Mechanism mechanism) {
        Debug.echoError((String)"Cannot apply properties to a Towny town!");
    }
}

