/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.objects.skillapi;

import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.TagContext;
import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.classes.RPGClass;

public class SkillAPIClassTag
implements ObjectTag {
    RPGClass rpgClass;
    private String prefix = "SkillAPIClass";

    public static SkillAPIClassTag valueOf(String string) {
        return SkillAPIClassTag.valueOf(string, null);
    }

    @Fetchable(value="skillapiclass")
    public static SkillAPIClassTag valueOf(String string, TagContext context) {
        if (string == null) {
            return null;
        }
        RPGClass rpgClass = SkillAPI.getClass((String)(string = string.replace("skillapiclass@", "")));
        if (rpgClass != null) {
            return new SkillAPIClassTag(rpgClass);
        }
        return null;
    }

    public static boolean matches(String arg) {
        return SkillAPIClassTag.valueOf(arg) != null;
    }

    public SkillAPIClassTag(RPGClass rpgClass) {
        this.rpgClass = rpgClass;
    }

    public RPGClass getRPGClass() {
        return this.rpgClass;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public ObjectTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public String debug() {
        return this.prefix + "='<A>" + this.identify() + "<G>' ";
    }

    public boolean isUnique() {
        return true;
    }

    public String getObjectType() {
        return "SkillAPI Class";
    }

    public String identify() {
        return "skillapiclass@" + this.rpgClass.getName();
    }

    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    public String getAttribute(Attribute attribute) {
        if (attribute.startsWith("name")) {
            return new ElementTag(this.rpgClass.getName()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("prefix_color")) {
            return new ElementTag(this.rpgClass.getPrefixColor().toString()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("class_prefix")) {
            return new ElementTag(this.rpgClass.getPrefix()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("needs_permission")) {
            return new ElementTag(this.rpgClass.isNeedsPermission()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("group.name")) {
            return new ElementTag(this.rpgClass.getGroup()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("has_parent")) {
            return new ElementTag(this.rpgClass.hasParent()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("parent")) {
            return new SkillAPIClassTag(this.rpgClass.getParent()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("icon")) {
            return new ItemTag(this.rpgClass.getIcon()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("max_level")) {
            return new ElementTag(this.rpgClass.getMaxLevel()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("base_health")) {
            return new ElementTag(this.rpgClass.getBaseHealth()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("health_scale")) {
            return new ElementTag(this.rpgClass.getHealthScale()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("base_mana")) {
            return new ElementTag(this.rpgClass.getBaseMana()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("mana_scale")) {
            return new ElementTag(this.rpgClass.getManaScale()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("mana_name")) {
            return new ElementTag(this.rpgClass.getManaName()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("has_mana_regen")) {
            return new ElementTag(this.rpgClass.hasManaRegen()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("mana_regen")) {
            return new ElementTag(this.rpgClass.getManaRegen()).getAttribute(attribute.fulfill(1));
        }
        return new ElementTag(this.identify()).getAttribute(attribute);
    }
}

