/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.objects.shopkeepers;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.depenizen.bukkit.bridges.ShopkeepersBridge;
import com.nisovin.shopkeepers.api.ShopkeepersAPI;
import com.nisovin.shopkeepers.api.ShopkeepersPlugin;
import com.nisovin.shopkeepers.api.shopkeeper.Shopkeeper;
import com.nisovin.shopkeepers.api.shopkeeper.TradingRecipe;
import com.nisovin.shopkeepers.api.shopkeeper.player.PlayerShopkeeper;
import com.nisovin.shopkeepers.api.shopobjects.entity.EntityShopObject;
import java.util.UUID;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;

public class ShopKeeperTag
implements ObjectTag {
    private String prefix;
    Shopkeeper shopkeeper;

    public static ShopKeeperTag valueOf(String string) {
        return ShopKeeperTag.valueOf(string, null);
    }

    @Fetchable(value="shopkeeper")
    public static ShopKeeperTag valueOf(String string, TagContext context) {
        if (string == null) {
            return null;
        }
        try {
            UUID uuid = UUID.fromString(string);
            Shopkeeper keeper = ShopkeepersAPI.getShopkeeperRegistry().getShopkeeperByUniqueId(uuid);
            if (keeper == null) {
                return null;
            }
            return new ShopKeeperTag(keeper);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean matches(String string) {
        return ShopKeeperTag.valueOf(string) != null;
    }

    public static boolean isShopKeeper(EntityTag entity) {
        if (entity == null) {
            return false;
        }
        return ((ShopkeepersPlugin)ShopkeepersBridge.instance.plugin).getShopkeeperRegistry().isShopkeeper(entity.getBukkitEntity());
    }

    public static ShopKeeperTag fromEntity(EntityTag entity) {
        if (!ShopKeeperTag.isShopKeeper(entity)) {
            return null;
        }
        return new ShopKeeperTag(ShopkeepersAPI.getShopkeeperRegistry().getShopkeeperByEntity(entity.getBukkitEntity()));
    }

    public ShopKeeperTag(Shopkeeper shopkeeper) {
        if (shopkeeper != null) {
            this.shopkeeper = shopkeeper;
        } else {
            Debug.echoError((String)"Shopkeeper referenced is null!");
        }
    }

    public Shopkeeper getShopkeeper() {
        return this.shopkeeper;
    }

    public EntityTag getDenizenEntity() {
        return new EntityTag(this.getBukkitEntity());
    }

    public Entity getBukkitEntity() {
        if (this.shopkeeper.getShopObject() instanceof EntityShopObject) {
            return ((EntityShopObject)this.shopkeeper.getShopObject()).getEntity();
        }
        return null;
    }

    public ObjectTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String debug() {
        return this.prefix + "='<A>" + this.identify() + "<G>' ";
    }

    public boolean isUnique() {
        return true;
    }

    public String getObjectType() {
        return "ShopKeeper";
    }

    public String identify() {
        return "shopkeeper@" + this.shopkeeper.getUniqueId();
    }

    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("is_active")) {
            return new ElementTag(this.shopkeeper.isActive()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_ui_active")) {
            return new ElementTag(this.shopkeeper.isUIActive()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("trades") || attribute.startsWith("recipes")) {
            ListTag trades = new ListTag();
            for (TradingRecipe trade : this.shopkeeper.getTradingRecipes(null)) {
                ListTag recipe = ShopKeeperTag.wrapTradingRecipe(trade);
                trades.addObject((ObjectTag)recipe);
            }
            return trades.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("entity")) {
            return this.getDenizenEntity().getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("owner")) {
            if (this.shopkeeper instanceof PlayerShopkeeper) {
                return new PlayerTag(((PlayerShopkeeper)this.shopkeeper).getOwnerUUID()).getAttribute(attribute.fulfill(1));
            }
            return null;
        }
        return null;
    }

    public static ListTag wrapTradingRecipe(TradingRecipe tradingRecipe) {
        ItemStack item1 = tradingRecipe.getItem1();
        ItemStack item2 = tradingRecipe.getItem2();
        ItemStack resultItem = tradingRecipe.getResultItem();
        ListTag recipe = new ListTag();
        recipe.addObject((ObjectTag)new ItemTag(item1));
        recipe.addObject((ObjectTag)new ItemTag(item2));
        recipe.addObject((ObjectTag)new ItemTag(resultItem));
        return recipe;
    }
}

