/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.objects.residence;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import org.bukkit.Location;

public class ResidenceTag
implements ObjectTag {
    ClaimedResidence residence = null;
    String prefix = "Residence";

    public static ResidenceTag valueOf(String string) {
        return ResidenceTag.valueOf(string, null);
    }

    @Fetchable(value="residence")
    public static ResidenceTag valueOf(String string, TagContext context) {
        if (string == null) {
            return null;
        }
        string = string.replace("residence@", "");
        ClaimedResidence residence = Residence.getInstance().getResidenceManagerAPI().getByName(string);
        if (residence == null) {
            return null;
        }
        return new ResidenceTag(residence);
    }

    public static boolean matches(String arg) {
        arg = arg.replace("residence@", "");
        return Residence.getInstance().getResidenceManagerAPI().getByName(arg) != null;
    }

    public ResidenceTag(ClaimedResidence residence) {
        if (residence != null) {
            this.residence = residence;
        } else {
            Debug.echoError((String)"Residence referenced is null!");
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String debug() {
        return this.prefix + "='<A>" + this.identify() + "<G>' ";
    }

    public boolean isUnique() {
        return true;
    }

    public String getObjectType() {
        return "Residence";
    }

    public String identify() {
        return "residence@" + this.residence.getName();
    }

    public String identifySimple() {
        return this.identify();
    }

    public ObjectTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public ClaimedResidence getResidence() {
        return this.residence;
    }

    public boolean equals(ResidenceTag residence) {
        return CoreUtilities.equalsIgnoreCase((String)residence.getResidence().getName(), (String)this.getResidence().getName());
    }

    public String toString() {
        return this.identify();
    }

    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("name")) {
            return new ElementTag(this.residence.getName()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("owner")) {
            return new PlayerTag(this.residence.getOwnerUUID()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_within") && attribute.hasContext(1)) {
            LocationTag location = (LocationTag)attribute.contextAsType(1, LocationTag.class);
            return new ElementTag(this.residence.containsLoc((Location)location)).getAttribute(attribute.fulfill(1));
        }
        return new ElementTag(this.identify()).getAttribute(attribute);
    }
}

