/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.objects.mythicmobs;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.depenizen.bukkit.bridges.MythicMobsBridge;
import com.denizenscript.depenizen.bukkit.objects.mythicmobs.MythicMobsMobTag;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.mobs.MythicMob;
import io.lumine.xikage.mythicmobs.spawning.spawners.MythicSpawner;
import java.util.ArrayList;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.World;

public class MythicSpawnerTag
implements ObjectTag,
Adjustable {
    private String prefix;
    MythicSpawner spawner;
    public static ObjectTagProcessor<MythicSpawnerTag> tagProcessor = new ObjectTagProcessor();

    public static MythicSpawnerTag valueOf(String name) {
        return MythicSpawnerTag.valueOf(name, null);
    }

    @Fetchable(value="mythicspawner")
    public static MythicSpawnerTag valueOf(String string, TagContext context) {
        if (string == null) {
            return null;
        }
        try {
            string = string.replace("mythicspawner@", "");
            if (!MythicMobsBridge.isMythicSpawner(string)) {
                return null;
            }
            return new MythicSpawnerTag(MythicMobsBridge.getMythicSpawner(string));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean matches(String string) {
        return MythicSpawnerTag.valueOf(string) != null;
    }

    public MythicSpawnerTag(MythicSpawner spawner) {
        this.spawner = spawner;
    }

    public MythicSpawner getSpawner() {
        return this.spawner;
    }

    public ObjectTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute((ObjectTag)this, attribute);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String debug() {
        return this.prefix + "='<A>" + this.identify() + "<G>' ";
    }

    public boolean isUnique() {
        return true;
    }

    public String getObjectType() {
        return "MythicSpawner";
    }

    public String identify() {
        return "mythicspawner@" + this.spawner.getName();
    }

    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    public static void registerTag(String name, TagRunnable.ObjectInterface<MythicSpawnerTag> runnable, String ... variants) {
        tagProcessor.registerTag(name, runnable, variants);
    }

    public static void registerTags() {
        MythicSpawnerTag.registerTag("name", (TagRunnable.ObjectInterface<MythicSpawnerTag>)((TagRunnable.ObjectInterface)(attribute, object) -> new ElementTag(object.getSpawner().getName())), new String[0]);
        MythicSpawnerTag.registerTag("cooldown", (TagRunnable.ObjectInterface<MythicSpawnerTag>)((TagRunnable.ObjectInterface)(attribute, object) -> new DurationTag(object.getSpawner().getCooldownSeconds())), new String[0]);
        MythicSpawnerTag.registerTag("mythic_mobs", (TagRunnable.ObjectInterface<MythicSpawnerTag>)((TagRunnable.ObjectInterface)(attribute, object) -> {
            ListTag list = new ListTag();
            for (UUID uuid : object.getSpawner().getAssociatedMobs()) {
                list.addObject((ObjectTag)MythicMobsMobTag.valueOf(uuid.toString()));
            }
            return list;
        }), new String[0]);
        MythicSpawnerTag.registerTag("mob_type", (TagRunnable.ObjectInterface<MythicSpawnerTag>)((TagRunnable.ObjectInterface)(attribute, object) -> new ElementTag(object.getSpawner().getTypeName())), new String[0]);
        MythicSpawnerTag.registerTag("mobs", (TagRunnable.ObjectInterface<MythicSpawnerTag>)((TagRunnable.ObjectInterface)(attribute, object) -> {
            ArrayList<EntityTag> list = new ArrayList<EntityTag>();
            for (UUID uuid : object.getSpawner().getAssociatedMobs()) {
                list.add(new EntityTag(MythicMobsMobTag.valueOf(uuid.toString()).getEntity()));
            }
            return new ListTag(list);
        }), new String[0]);
        MythicSpawnerTag.registerTag("location", (TagRunnable.ObjectInterface<MythicSpawnerTag>)((TagRunnable.ObjectInterface)(attribute, object) -> {
            AbstractLocation loc = object.getSpawner().getLocation();
            return new LocationTag((World)loc.getWorld(), loc.getX(), loc.getY(), loc.getZ());
        }), new String[0]);
        MythicSpawnerTag.registerTag("group", (TagRunnable.ObjectInterface<MythicSpawnerTag>)((TagRunnable.ObjectInterface)(attribute, object) -> new ElementTag(object.getSpawner().getGroup())), new String[0]);
    }

    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("group")) {
            this.spawner.setGroup(mechanism.getValue().asString());
        } else if (mechanism.matches("location") && mechanism.requireObject(LocationTag.class)) {
            this.spawner.setLocation(BukkitAdapter.adapt((Location)((Location)mechanism.valueAsType(LocationTag.class))));
        } else if (mechanism.matches("cooldown") && mechanism.requireObject(DurationTag.class)) {
            this.spawner.setCooldownSeconds(((DurationTag)mechanism.valueAsType(DurationTag.class)).getSecondsAsInt());
        } else if (mechanism.matches("start_cooldown")) {
            this.spawner.setOnCooldown();
        } else if (mechanism.matches("mob_type")) {
            MythicMob mob = MythicMobsBridge.getMythicMob(mechanism.getValue().asString());
            if (mob == null) {
                Debug.echoError((String)("MythicMob type does not exist: " + mechanism.getValue().asString()));
                return;
            }
            this.spawner.setType(mechanism.getValue().asString());
        } else if (mechanism.matches("spawn")) {
            this.spawner.Spawn();
        } else if (mechanism.matches("enable")) {
            this.spawner.Enable();
        } else if (mechanism.matches("disable")) {
            this.spawner.Disable();
        }
    }

    public void applyProperty(Mechanism mechanism) {
        Debug.echoError((String)"Cannot apply properties to a MythicSpawner!");
    }
}

