/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.objects.mythicmobs;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.depenizen.bukkit.bridges.MythicMobsBridge;
import com.denizenscript.depenizen.bukkit.objects.mythicmobs.MythicSpawnerTag;
import com.google.common.collect.ImmutableMap;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitEntity;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.mobs.MythicMob;
import java.util.UUID;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;

public class MythicMobsMobTag
implements ObjectTag,
Adjustable {
    private String prefix;
    ActiveMob mob;
    MythicMob mobType;
    public static ObjectTagProcessor<MythicMobsMobTag> tagProcessor = new ObjectTagProcessor();

    public static MythicMobsMobTag valueOf(String uuid) {
        return MythicMobsMobTag.valueOf(uuid, null);
    }

    @Fetchable(value="mythicmob")
    public static MythicMobsMobTag valueOf(String string, TagContext context) {
        if (string == null) {
            return null;
        }
        try {
            string = string.replace("mythicmob@", "");
            UUID uuid = UUID.fromString(string);
            if (!MythicMobsBridge.isMythicMob(uuid)) {
                return null;
            }
            return new MythicMobsMobTag(MythicMobsBridge.getActiveMob(EntityTag.getEntityForID((UUID)uuid)));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean matches(String string) {
        return MythicMobsMobTag.valueOf(string) != null;
    }

    public MythicMobsMobTag(ActiveMob mob) {
        if (mob != null) {
            this.mob = mob;
            this.mobType = mob.getType();
        } else {
            Debug.echoError((String)"ActiveMob referenced is null!");
        }
    }

    public ActiveMob getMob() {
        return this.mob;
    }

    public MythicMob getMobType() {
        return this.mobType;
    }

    public LivingEntity getLivingEntity() {
        return (LivingEntity)this.mob.getEntity().getBukkitEntity();
    }

    public Entity getEntity() {
        return this.mob.getEntity().getBukkitEntity();
    }

    public ObjectTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute((ObjectTag)this, attribute);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String debug() {
        return this.prefix + "='<A>" + this.identify() + "<G>' ";
    }

    public boolean isUnique() {
        return true;
    }

    public String getObjectType() {
        return "MythicMob";
    }

    public String identify() {
        return "mythicmob@" + this.mob.getUniqueId();
    }

    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    public static void registerTag(String name, TagRunnable.ObjectInterface<MythicMobsMobTag> runnable, String ... variants) {
        tagProcessor.registerTag(name, runnable, variants);
    }

    public static void registerTags() {
        MythicMobsMobTag.registerTag("internal_name", (TagRunnable.ObjectInterface<MythicMobsMobTag>)((TagRunnable.ObjectInterface)(attribute, object) -> new ElementTag(object.getMobType().getInternalName())), new String[0]);
        MythicMobsMobTag.registerTag("display_name", (TagRunnable.ObjectInterface<MythicMobsMobTag>)((TagRunnable.ObjectInterface)(attribute, object) -> new ElementTag(object.getMob().getDisplayName())), new String[0]);
        MythicMobsMobTag.registerTag("spawner_name", (TagRunnable.ObjectInterface<MythicMobsMobTag>)((TagRunnable.ObjectInterface)(attribute, object) -> {
            if (object.getMob().getSpawner() == null) {
                return null;
            }
            return new ElementTag(object.getMob().getSpawner().getName());
        }), new String[0]);
        MythicMobsMobTag.registerTag("spawner", (TagRunnable.ObjectInterface<MythicMobsMobTag>)((TagRunnable.ObjectInterface)(attribute, object) -> {
            if (object.getMob().getSpawner() == null) {
                return null;
            }
            return new MythicSpawnerTag(object.getMob().getSpawner());
        }), new String[0]);
        MythicMobsMobTag.registerTag("level", (TagRunnable.ObjectInterface<MythicMobsMobTag>)((TagRunnable.ObjectInterface)(attribute, object) -> new ElementTag(object.getMob().getLevel())), new String[0]);
        MythicMobsMobTag.registerTag("players_killed", (TagRunnable.ObjectInterface<MythicMobsMobTag>)((TagRunnable.ObjectInterface)(attribute, object) -> new ElementTag(object.getMob().getPlayerKills())), new String[0]);
        MythicMobsMobTag.registerTag("damage", (TagRunnable.ObjectInterface<MythicMobsMobTag>)((TagRunnable.ObjectInterface)(attribute, object) -> new ElementTag(object.getMob().getDamage())), new String[0]);
        MythicMobsMobTag.registerTag("armor", (TagRunnable.ObjectInterface<MythicMobsMobTag>)((TagRunnable.ObjectInterface)(attribute, object) -> new ElementTag(object.getMob().getArmor())), new String[0]);
        MythicMobsMobTag.registerTag("has_target", (TagRunnable.ObjectInterface<MythicMobsMobTag>)((TagRunnable.ObjectInterface)(attribute, object) -> new ElementTag(object.getMob().hasTarget())), new String[0]);
        MythicMobsMobTag.registerTag("target", (TagRunnable.ObjectInterface<MythicMobsMobTag>)((TagRunnable.ObjectInterface)(attribute, object) -> {
            AbstractEntity target = object.getMob().getThreatTable().getTopThreatHolder();
            if (target == null) {
                return null;
            }
            return new EntityTag(target.getBukkitEntity());
        }), new String[0]);
        MythicMobsMobTag.registerTag("has_threat_table", (TagRunnable.ObjectInterface<MythicMobsMobTag>)((TagRunnable.ObjectInterface)(attribute, object) -> new ElementTag(object.getMob().hasThreatTable())), new String[0]);
        MythicMobsMobTag.registerTag("threat_table", (TagRunnable.ObjectInterface<MythicMobsMobTag>)((TagRunnable.ObjectInterface)(attribute, object) -> {
            if (!object.getMob().hasThreatTable()) {
                return null;
            }
            ImmutableMap table = object.getMob().getThreatTable().asMap();
            MapTag map = new MapTag();
            for (AbstractEntity entity : table.keySet()) {
                map.putObject(entity.getUniqueId().toString(), (ObjectTag)new ElementTag(((Double)table.get(entity)).doubleValue()));
            }
            return map;
        }), new String[0]);
        MythicMobsMobTag.registerTag("threat_table_players", (TagRunnable.ObjectInterface<MythicMobsMobTag>)((TagRunnable.ObjectInterface)(attribute, object) -> {
            if (!object.getMob().hasThreatTable()) {
                return null;
            }
            ImmutableMap table = object.getMob().getThreatTable().asMap();
            MapTag map = new MapTag();
            for (AbstractEntity entity : table.keySet()) {
                if (!entity.isPlayer()) continue;
                map.putObject(entity.getUniqueId().toString(), (ObjectTag)new ElementTag(((Double)table.get(entity)).doubleValue()));
            }
            return map;
        }), new String[0]);
        MythicMobsMobTag.registerTag("is_damaging", (TagRunnable.ObjectInterface<MythicMobsMobTag>)((TagRunnable.ObjectInterface)(attribute, object) -> new ElementTag(object.getMob().isUsingDamageSkill())), new String[0]);
        MythicMobsMobTag.registerTag("stance", (TagRunnable.ObjectInterface<MythicMobsMobTag>)((TagRunnable.ObjectInterface)(attribute, object) -> new ElementTag(object.getMob().getStance())), new String[0]);
        MythicMobsMobTag.registerTag("entity", (TagRunnable.ObjectInterface<MythicMobsMobTag>)((TagRunnable.ObjectInterface)(attribute, object) -> new EntityTag(object.getMob().getEntity().getBukkitEntity())), new String[0]);
        MythicMobsMobTag.registerTag("global_cooldown", (TagRunnable.ObjectInterface<MythicMobsMobTag>)((TagRunnable.ObjectInterface)(attribute, object) -> new DurationTag(object.getMob().getGlobalCooldown())), new String[0]);
    }

    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("global_cooldown") && mechanism.requireInteger()) {
            this.mob.setGlobalCooldown(mechanism.getValue().asInt());
        }
        if (mechanism.matches("stance")) {
            this.mob.setStance(mechanism.getValue().asString());
        } else if (mechanism.matches("reset_target")) {
            this.mob.resetTarget();
        } else if (mechanism.matches("level") && mechanism.requireInteger()) {
            this.mob.setLevel((double)mechanism.getValue().asInt());
        } else if (mechanism.matches("target") && mechanism.requireObject(EntityTag.class)) {
            EntityTag mTarget = (EntityTag)mechanism.valueAsType(EntityTag.class);
            if (mTarget == null || !mTarget.isValid() || mTarget.getLivingEntity() == null) {
                return;
            }
            BukkitEntity target = new BukkitEntity(mTarget.getBukkitEntity());
            this.mob.setTarget((AbstractEntity)target);
        }
        CoreUtilities.autoPropertyMechanism((ObjectTag)this, (Mechanism)mechanism);
        if (!mechanism.fulfilled()) {
            mechanism.reportInvalid();
        }
    }

    public void applyProperty(Mechanism mechanism) {
        Debug.echoError((String)"Cannot apply properties to a MythicMob!");
    }
}

