/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.objects.luckperms;

import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.depenizen.bukkit.bridges.LuckPermsBridge;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.luckperms.api.model.user.User;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.NodeType;
import net.luckperms.api.node.types.InheritanceNode;
import net.luckperms.api.query.QueryOptions;
import net.luckperms.api.track.Track;

public class LuckPermsTrackTag
implements ObjectTag {
    Track track;
    private String prefix = "LuckPermsTrack";

    public static LuckPermsTrackTag valueOf(String string) {
        return LuckPermsTrackTag.valueOf(string, null);
    }

    @Fetchable(value="luckpermstrack")
    public static LuckPermsTrackTag valueOf(String string, TagContext context) {
        if (string == null) {
            return null;
        }
        string = string.replace("luckpermstrack@", "");
        try {
            Track track = LuckPermsBridge.luckPermsInstance.getTrackManager().getTrack(string);
            if (track == null) {
                return null;
            }
            return new LuckPermsTrackTag(track);
        }
        catch (Throwable e) {
            Debug.echoError((Throwable)e);
            return null;
        }
    }

    public static boolean matches(String arg) {
        return arg.startsWith("luckpermstrack@");
    }

    public LuckPermsTrackTag(Track t) {
        this.track = t;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public LuckPermsTrackTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public int hashCode() {
        return this.track.hashCode();
    }

    public boolean equals(Object a) {
        if (a instanceof LuckPermsTrackTag) {
            return ((LuckPermsTrackTag)a).track.getName().equals(this.track.getName());
        }
        return false;
    }

    public String debug() {
        return this.prefix + "='<A>" + this.identify() + "<G>' ";
    }

    public boolean isUnique() {
        return true;
    }

    public String getObjectType() {
        return "LuckPermsTrack";
    }

    public String identify() {
        return "luckpermstrack@" + this.track.getName();
    }

    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    public String getAttribute(Attribute attribute) {
        if (attribute.startsWith("name")) {
            return new ElementTag(this.track.getName()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("groups")) {
            ListTag groups = new ListTag();
            if (attribute.hasContext(1)) {
                PlayerTag player = (PlayerTag)attribute.contextAsType(1, PlayerTag.class);
                if (player == null) {
                    attribute.echoError("Invalid player input for 'group' tag.");
                    return null;
                }
                User user = LuckPermsBridge.luckPermsInstance.getUserManager().getUser(player.getUUID());
                List trackGroups = this.track.getGroups();
                List memberGroups = user.resolveInheritedNodes(QueryOptions.nonContextual()).stream().filter(arg_0 -> ((NodeType)NodeType.INHERITANCE).matches(arg_0)).map(arg_0 -> ((NodeType)NodeType.INHERITANCE).cast(arg_0)).filter(Node::getValue).filter(n -> trackGroups.contains(n.getGroupName())).map(InheritanceNode::getGroupName).collect(Collectors.toList());
                groups.addAll(memberGroups);
            } else {
                groups.addAll((Collection)this.track.getGroups());
            }
            return groups.getAttribute(attribute.fulfill(1));
        }
        return new ElementTag(this.identify()).getAttribute(attribute);
    }
}

