/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.objects.jobs;

import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.TagContext;
import com.gamingmesh.jobs.Jobs;
import com.gamingmesh.jobs.container.Job;
import com.gamingmesh.jobs.container.JobProgression;
import com.gamingmesh.jobs.container.JobsPlayer;

public class JobsJobTag
implements ObjectTag {
    Job job;
    JobProgression jobProgression = null;
    JobsPlayer jobOwner = null;
    private String prefix = "Job";

    public static JobsJobTag valueOf(String string) {
        return JobsJobTag.valueOf(string, null);
    }

    @Fetchable(value="job")
    public static JobsJobTag valueOf(String string, TagContext context) {
        if (string == null) {
            return null;
        }
        Object job = null;
        if (ObjectFetcher.isObjectWithProperties((String)string)) {
            return (JobsJobTag)ObjectFetcher.getObjectFromWithProperties(JobsJobTag.class, (String)string, (TagContext)context);
        }
        return new JobsJobTag(Jobs.getJob((String)string.replace("job@", "")));
    }

    public static boolean matches(String arg) {
        return JobsJobTag.valueOf(arg) != null;
    }

    public JobsJobTag(Job job) {
        this.job = job;
    }

    public JobsJobTag(Job job, JobsPlayer jobOwner) {
        this.job = job;
        this.jobProgression = jobOwner.getJobProgression(job);
        this.jobOwner = jobOwner;
    }

    public Job getJob() {
        return this.job;
    }

    public JobsJobTag setJobProgression(JobProgression jobProgression) {
        this.jobProgression = jobProgression;
        return this;
    }

    public boolean hasOwner() {
        return this.jobOwner != null;
    }

    public PlayerTag getOwner() {
        return new PlayerTag(this.jobOwner.getPlayerUUID());
    }

    public void setOwner(PlayerTag player) {
        this.jobOwner = Jobs.getPlayerManager().getJobsPlayer(player.getName());
        this.jobProgression = this.jobOwner.getJobProgression(this.job);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public ObjectTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public String debug() {
        return this.prefix + "='<A>" + this.identify() + "<G>' ";
    }

    public boolean isUnique() {
        return true;
    }

    public String getObjectType() {
        return "Job";
    }

    public String identify() {
        return "job@" + this.job.getName() + PropertyParser.getPropertiesString((ObjectTag)this);
    }

    public String identifySimple() {
        return "job@" + this.job.getName();
    }

    public String toString() {
        return this.identify();
    }

    public String getAttribute(Attribute attribute) {
        if (this.jobProgression != null && attribute.startsWith("xp")) {
            if ((attribute = attribute.fulfill(1)).startsWith("max")) {
                return new ElementTag(this.jobProgression.getMaxExperience()).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("level")) {
                return new ElementTag(this.jobProgression.getLevel()).getAttribute(attribute.fulfill(1));
            }
            return new ElementTag(this.jobProgression.getExperience()).getAttribute(attribute);
        }
        if (attribute.startsWith("color")) {
            return new ElementTag(this.job.getChatColor().toString()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("description")) {
            return new ElementTag(this.job.getDescription()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("name")) {
            if ((attribute = attribute.fulfill(1)).startsWith("short")) {
                return new ElementTag(this.job.getShortName()).getAttribute(attribute.fulfill(1));
            }
            return new ElementTag(this.job.getName()).getAttribute(attribute);
        }
        return new ElementTag(this.identify()).getAttribute(attribute);
    }
}

