/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.objects.griefprevention;

import com.denizenscript.denizen.objects.ChunkTag;
import com.denizenscript.denizen.objects.CuboidTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.ArrayList;
import java.util.UUID;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.DataStore;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import org.bukkit.Chunk;
import org.bukkit.Location;

public class GriefPreventionClaimTag
implements ObjectTag,
Adjustable {
    static DataStore dataStore = GriefPrevention.instance.dataStore;
    private String prefix;
    Claim claim;

    public static boolean matches(String id) {
        return GriefPreventionClaimTag.valueOf(id) != null;
    }

    public static GriefPreventionClaimTag valueOf(String id) {
        return GriefPreventionClaimTag.valueOf(id, null);
    }

    @Fetchable(value="gpclaim")
    public static GriefPreventionClaimTag valueOf(String id, TagContext context) {
        long claimID;
        id = id.replace("gpclaim@", "");
        try {
            claimID = Long.valueOf(id);
        }
        catch (NumberFormatException e) {
            return null;
        }
        Claim claim = dataStore.getClaim(claimID);
        if (claim == null) {
            return null;
        }
        return new GriefPreventionClaimTag(claim);
    }

    public GriefPreventionClaimTag(Claim claim) {
        this.claim = claim;
    }

    public ObjectTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String debug() {
        return this.prefix + "='<A>" + this.identify() + "<G>' ";
    }

    public boolean isUnique() {
        return true;
    }

    public String getObjectType() {
        return "GriefPreventionClaim";
    }

    public String identify() {
        return "gpclaim@" + this.claim.getID();
    }

    public String toString() {
        return this.identify();
    }

    public String simple() {
        return String.valueOf(this.claim.getID());
    }

    public String identifySimple() {
        return this.identify();
    }

    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("id")) {
            return new ElementTag(this.claim.getID().longValue()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("managers")) {
            ListTag managers = new ListTag();
            for (String manager : this.claim.managers) {
                managers.addObject((ObjectTag)new PlayerTag(UUID.fromString(manager)));
            }
            return managers.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("trusted")) {
            ListTag trusted = new ListTag();
            ArrayList b = new ArrayList();
            this.claim.getPermissions(b, new ArrayList(), new ArrayList(), new ArrayList());
            for (String trust : b) {
                trusted.addObject((ObjectTag)new PlayerTag(UUID.fromString(trust)));
            }
            return trusted.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("builders")) {
            ListTag trusted = new ListTag();
            ArrayList b = new ArrayList();
            this.claim.getPermissions(b, new ArrayList(), new ArrayList(), new ArrayList());
            for (String trust : b) {
                trusted.addObject((ObjectTag)new PlayerTag(UUID.fromString(trust)));
            }
            return trusted.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("containers")) {
            ListTag trusted = new ListTag();
            ArrayList c = new ArrayList();
            this.claim.getPermissions(new ArrayList(), c, new ArrayList(), new ArrayList());
            for (String container : c) {
                trusted.addObject((ObjectTag)new PlayerTag(UUID.fromString(container)));
            }
            return trusted.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("accessors")) {
            ListTag trusted = new ListTag();
            ArrayList a = new ArrayList();
            this.claim.getPermissions(new ArrayList(), new ArrayList(), a, new ArrayList());
            for (String access : a) {
                trusted.addObject((ObjectTag)new PlayerTag(UUID.fromString(access)));
            }
            return trusted.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("owner")) {
            if (this.claim.isAdminClaim()) {
                return new ElementTag("Admin").getAttribute(attribute.fulfill(1));
            }
            return new PlayerTag(this.claim.ownerID).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("cuboid")) {
            LocationTag lower = new LocationTag(this.claim.getLesserBoundaryCorner());
            lower.setY(0.0);
            LocationTag upper = new LocationTag(this.claim.getGreaterBoundaryCorner());
            upper.setY(255.0);
            return new CuboidTag((Location)lower, (Location)upper).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_adminclaim") || attribute.startsWith("is_admin_claim")) {
            return new ElementTag(this.claim.isAdminClaim()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("chunks")) {
            ListTag chunks = new ListTag();
            for (Chunk chunk : this.claim.getChunks()) {
                chunks.addObject((ObjectTag)new ChunkTag(chunk));
            }
            return chunks.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("can_siege") && attribute.hasContext(1)) {
            PlayerTag defender = (PlayerTag)attribute.contextAsType(1, PlayerTag.class);
            if (defender == null || defender.getPlayerEntity() == null) {
                return null;
            }
            return new ElementTag(this.claim.canSiege(defender.getPlayerEntity())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_sieged")) {
            return new ElementTag(this.claim.siegeData != null).getAttribute(attribute.fulfill(1));
        }
        return new ElementTag(this.identify()).getAttribute(attribute);
    }

    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("owner")) {
            try {
                if (PlayerTag.matches((String)mechanism.getValue().asString())) {
                    PlayerTag player = (PlayerTag)mechanism.valueAsType(PlayerTag.class);
                    dataStore.changeClaimOwner(this.claim, player.getUUID());
                } else if (CoreUtilities.equalsIgnoreCase((String)mechanism.getValue().asString(), (String)"admin")) {
                    dataStore.changeClaimOwner(this.claim, null);
                }
            }
            catch (Exception e) {
                Debug.echoError((String)("Unable to transfer ownership of claim: " + this.identify() + "."));
            }
        }
        if (mechanism.matches("depth") && mechanism.requireInteger()) {
            dataStore.extendClaim(this.claim, mechanism.getValue().asInt());
        }
        for (Property property : PropertyParser.getProperties((ObjectTag)this)) {
            property.adjust(mechanism);
            if (!mechanism.fulfilled()) continue;
            break;
        }
        if (!mechanism.fulfilled()) {
            mechanism.reportInvalid();
        }
    }

    public void applyProperty(Mechanism mechanism) {
        Debug.echoError((String)"Cannot apply Properties to a GriefPreventionClaim!");
    }
}

