/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.objects.factions;

import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.depenizen.bukkit.objects.towny.TownTag;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.exceptions.EconomyException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;

public class NationTag
implements ObjectTag {
    Nation nation = null;
    private String prefix = "Nation";

    public static NationTag valueOf(String string) {
        return NationTag.valueOf(string, null);
    }

    @Fetchable(value="nation")
    public static NationTag valueOf(String string, TagContext context) {
        if (string == null) {
            return null;
        }
        string = string.replace("nation@", "");
        Nation nation = TownyUniverse.getInstance().getNation(string);
        if (nation == null) {
            return null;
        }
        return new NationTag(nation);
    }

    public static boolean matches(String arg) {
        arg = arg.replace("nation@", "");
        return TownyUniverse.getInstance().hasNation(arg);
    }

    public NationTag(Nation nation) {
        if (nation != null) {
            this.nation = nation;
        } else {
            Debug.echoError((String)"Nation referenced is null!");
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    public NationTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public String debug() {
        return this.prefix + "='<A>" + this.identify() + "<G>' ";
    }

    public boolean isUnique() {
        return true;
    }

    public String getObjectType() {
        return "Nation";
    }

    public String identify() {
        return "nation@" + this.nation.getName();
    }

    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    public String getAttribute(Attribute attribute) {
        if (attribute.startsWith("allies")) {
            ListTag list = new ListTag();
            for (Nation ally : this.nation.getAllies()) {
                list.addObject((ObjectTag)new NationTag(ally));
            }
            return list.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("assistants")) {
            ListTag list = new ListTag();
            for (Resident resident : this.nation.getAssistants()) {
                list.addObject((ObjectTag)PlayerTag.valueOf((String)resident.getName(), (TagContext)attribute.context));
            }
            return list.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("balance")) {
            try {
                return new ElementTag(this.nation.getAccount().getHoldingBalance()).getAttribute(attribute.fulfill(1));
            }
            catch (EconomyException e) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError((String)"Invalid economy response!");
                }
            }
        } else if (attribute.startsWith("capital") && this.nation.hasCapital()) {
            return new TownTag(this.nation.getCapital()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("enemies")) {
            ListTag list = new ListTag();
            for (Nation enemy : this.nation.getEnemies()) {
                list.addObject((ObjectTag)new NationTag(enemy));
            }
            return list.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("isneutral") || attribute.startsWith("is_neutral")) {
            return new ElementTag(this.nation.isNeutral()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("king")) {
            return PlayerTag.valueOf((String)this.nation.getCapital().getMayor().getName(), (TagContext)attribute.context).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("name")) {
            return new ElementTag(this.nation.getName()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("playercount") || attribute.startsWith("player_count")) {
            return new ElementTag(this.nation.getNumResidents()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("relation")) {
            try {
                NationTag to = NationTag.valueOf(attribute.getContext(1));
                if (this.nation.hasAlly(to.nation)) {
                    return new ElementTag("allies").getAttribute(attribute.fulfill(1));
                }
                if (this.nation.hasEnemy(to.nation)) {
                    return new ElementTag("enemies").getAttribute(attribute.fulfill(1));
                }
                return new ElementTag("neutral").getAttribute(attribute.fulfill(1));
            }
            catch (Exception to) {
                // empty catch block
            }
        }
        if (attribute.startsWith("residents")) {
            ListTag list = new ListTag();
            for (Resident resident : this.nation.getResidents()) {
                list.addObject((ObjectTag)PlayerTag.valueOf((String)resident.getName(), (TagContext)attribute.context));
            }
            return list.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("tag")) {
            if (this.nation.hasTag()) {
                return new ElementTag(this.nation.getTag()).getAttribute(attribute.fulfill(1));
            }
        } else {
            if (attribute.startsWith("taxes")) {
                return new ElementTag(this.nation.getTaxes()).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("towncount") || attribute.startsWith("town_count")) {
                return new ElementTag(this.nation.getNumTowns()).getAttribute(attribute.fulfill(1));
            }
        }
        return new ElementTag(this.identify()).getAttribute(attribute);
    }
}

