/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.objects.factions;

import com.denizenscript.denizen.objects.ChunkTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.TagContext;
import com.massivecraft.factions.RelationParticipator;
import com.massivecraft.factions.entity.BoardColl;
import com.massivecraft.factions.entity.Faction;
import com.massivecraft.factions.entity.FactionColl;
import com.massivecraft.factions.entity.MFlag;
import com.massivecraft.factions.entity.MPlayer;
import com.massivecraft.factions.entity.Warp;
import com.massivecraft.massivecore.money.Money;
import com.massivecraft.massivecore.ps.PS;
import java.util.Set;

public class FactionTag
implements ObjectTag {
    Faction faction = null;
    private String prefix = "Faction";

    public static FactionTag valueOf(String string) {
        return FactionTag.valueOf(string, null);
    }

    @Fetchable(value="faction")
    public static FactionTag valueOf(String string, TagContext context) {
        if (string == null) {
            return null;
        }
        string = string.replace("faction@", "");
        Faction faction = FactionColl.get().getByName(string);
        if (faction != null) {
            return new FactionTag(faction);
        }
        return null;
    }

    public static boolean matches(String arg) {
        return FactionTag.valueOf(arg) != null;
    }

    public FactionTag(Faction faction) {
        if (faction != null) {
            this.faction = faction;
        } else {
            Debug.echoError((String)"Faction referenced is null!");
        }
    }

    public Faction getFaction() {
        return this.faction;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public ObjectTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public String debug() {
        return this.prefix + "='<A>" + this.identify() + "<G>' ";
    }

    public boolean isUnique() {
        return true;
    }

    public String getObjectType() {
        return "Faction";
    }

    public String identify() {
        return "faction@" + this.faction.getName();
    }

    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    public String getAttribute(Attribute attribute) {
        Set chunks;
        Warp warp;
        if (attribute.startsWith("balance")) {
            return new ElementTag(Money.get((Object)this.faction)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("warp") && attribute.hasContext(1)) {
            warp = this.faction.getWarp((Object)attribute.getContext(1));
            if (warp != null) {
                return new LocationTag(warp.getLocation().asBukkitLocation()).getAttribute(attribute.fulfill(1));
            }
        } else if (attribute.startsWith("home")) {
            warp = this.faction.getWarp((Object)"home");
            if (warp != null) {
                return new LocationTag(warp.getLocation().asBukkitLocation()).getAttribute(attribute.fulfill(1));
            }
        } else {
            if (attribute.startsWith("id")) {
                return new ElementTag(this.faction.getId()).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("isopen") || attribute.startsWith("is_open")) {
                return new ElementTag(this.faction.isOpen()).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("ispeaceful") || attribute.startsWith("is_peaceful")) {
                return new ElementTag(this.faction.getFlag(MFlag.getFlagPeaceful())).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("ispermanent") || attribute.startsWith("is_permanent")) {
                return new ElementTag(this.faction.getFlag(MFlag.getFlagPermanent())).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("leader")) {
                if (this.faction.getLeader() != null) {
                    return PlayerTag.valueOf((String)this.faction.getLeader().getName(), (TagContext)attribute.context).getAttribute(attribute.fulfill(1));
                }
            } else {
                if (attribute.startsWith("name")) {
                    return new ElementTag(this.faction.getName()).getAttribute(attribute.fulfill(1));
                }
                if (attribute.startsWith("playercount") || attribute.startsWith("player_count")) {
                    return new ElementTag(this.faction.getMPlayers().size()).getAttribute(attribute.fulfill(1));
                }
                if (attribute.startsWith("power")) {
                    return new ElementTag(this.faction.getPower()).getAttribute(attribute.fulfill(1));
                }
                if (attribute.startsWith("relation")) {
                    FactionTag to = FactionTag.valueOf(attribute.getContext(1));
                    if (to != null) {
                        return new ElementTag(this.faction.getRelationTo((RelationParticipator)to.getFaction()).toString()).getAttribute(attribute.fulfill(1));
                    }
                } else if (attribute.startsWith("size")) {
                    return new ElementTag(this.faction.getLandCount()).getAttribute(attribute.fulfill(1));
                }
            }
        }
        if (attribute.startsWith("claimed_chunks")) {
            chunks = BoardColl.get().getChunks(this.faction);
            ListTag dchunks = new ListTag();
            for (PS ps : chunks) {
                dchunks.addObject((ObjectTag)new ChunkTag(ps.asBukkitChunk()));
            }
            return dchunks.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("list_players")) {
            chunks = BoardColl.get().getChunks(this.faction);
            ListTag players = new ListTag();
            for (MPlayer ps : this.faction.getMPlayers()) {
                players.addObject((ObjectTag)PlayerTag.valueOf((String)this.faction.getLeader().getUuid().toString(), (TagContext)attribute.context));
            }
            return players.getAttribute(attribute.fulfill(1));
        }
        return new ElementTag(this.identify()).getAttribute(attribute);
    }
}

