/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.objects.bigdoors;

import com.denizenscript.denizen.objects.CuboidTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.depenizen.bukkit.bridges.BigDoorsBridge;
import nl.pim16aap2.bigDoors.Door;
import nl.pim16aap2.bigDoors.util.DoorOwner;

public class BigDoorsDoorTag
implements ObjectTag,
Adjustable {
    Door door;
    private String prefix = "BigDoorsDoor";
    public static ObjectTagProcessor<BigDoorsDoorTag> tagProcessor = new ObjectTagProcessor();

    @Fetchable(value="bigdoor")
    public static BigDoorsDoorTag valueOf(String string, TagContext context) {
        if (string == null || string.length() == 0) {
            return null;
        }
        if (string.startsWith("bigdoors@")) {
            string = string.substring("bigdoor@".length());
        }
        if (!ArgumentHelper.matchesInteger((String)string)) {
            return null;
        }
        return new BigDoorsDoorTag(BigDoorsBridge.commander.getDoor(null, (long)Integer.parseInt(string)));
    }

    public static boolean matches(String arg) {
        if (arg.startsWith("bigdoor@")) {
            return true;
        }
        return BigDoorsDoorTag.valueOf(arg, CoreUtilities.noDebugContext) != null;
    }

    public BigDoorsDoorTag(Door door) {
        this.door = door;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public ObjectTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public String debug() {
        return this.prefix + "='<A>" + this.identify() + "<G>' ";
    }

    public boolean isUnique() {
        return true;
    }

    public String getObjectType() {
        return "BigDoorsDoor";
    }

    public String identify() {
        return "bigdoor@" + this.door.getDoorUID();
    }

    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    public static void registerTags() {
        BigDoorsDoorTag.registerTag("is_open", (TagRunnable.ObjectInterface<BigDoorsDoorTag>)((TagRunnable.ObjectInterface)(attribute, object) -> new ElementTag(object.door.isOpen())), new String[0]);
        BigDoorsDoorTag.registerTag("is_locked", (TagRunnable.ObjectInterface<BigDoorsDoorTag>)((TagRunnable.ObjectInterface)(attribute, object) -> new ElementTag(object.door.isLocked())), new String[0]);
        BigDoorsDoorTag.registerTag("is_busy", (TagRunnable.ObjectInterface<BigDoorsDoorTag>)((TagRunnable.ObjectInterface)(attribute, object) -> new ElementTag(BigDoorsBridge.commander.isDoorBusy(object.door.getDoorUID()))), new String[0]);
        BigDoorsDoorTag.registerTag("is_loaded", (TagRunnable.ObjectInterface<BigDoorsDoorTag>)((TagRunnable.ObjectInterface)(attribute, object) -> new ElementTag(BigDoorsBridge.bigDoors.areChunksLoadedForDoor(object.door))), new String[0]);
        BigDoorsDoorTag.registerTag("cuboid", (TagRunnable.ObjectInterface<BigDoorsDoorTag>)((TagRunnable.ObjectInterface)(attribute, object) -> new CuboidTag(object.door.getMinimum(), object.door.getMaximum())), new String[0]);
        BigDoorsDoorTag.registerTag("auto_close", (TagRunnable.ObjectInterface<BigDoorsDoorTag>)((TagRunnable.ObjectInterface)(attribute, object) -> new DurationTag(object.door.getAutoClose())), new String[0]);
        BigDoorsDoorTag.registerTag("power_block", (TagRunnable.ObjectInterface<BigDoorsDoorTag>)((TagRunnable.ObjectInterface)(attribute, object) -> new LocationTag(object.door.getPowerBlockLoc())), new String[0]);
        BigDoorsDoorTag.registerTag("owners", (TagRunnable.ObjectInterface<BigDoorsDoorTag>)((TagRunnable.ObjectInterface)(attribute, object) -> {
            ListTag owners = new ListTag();
            for (DoorOwner owner : BigDoorsBridge.commander.getDoorOwners(object.door.getDoorUID(), null)) {
                owners.addObject((ObjectTag)new PlayerTag(owner.getPlayerUUID()));
            }
            return owners;
        }), new String[0]);
        BigDoorsDoorTag.registerTag("door_type", (TagRunnable.ObjectInterface<BigDoorsDoorTag>)((TagRunnable.ObjectInterface)(attribute, object) -> new ElementTag(object.door.getType().toString())), new String[0]);
        BigDoorsDoorTag.registerTag("name", (TagRunnable.ObjectInterface<BigDoorsDoorTag>)((TagRunnable.ObjectInterface)(attribute, object) -> new ElementTag(object.door.getName())), new String[0]);
    }

    public static void registerTag(String name, TagRunnable.ObjectInterface<BigDoorsDoorTag> runnable, String ... variants) {
        tagProcessor.registerTag(name, runnable, variants);
    }

    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute((ObjectTag)this, attribute);
    }

    public void applyProperty(Mechanism mechanism) {
        Debug.echoError((String)"Cannot apply Properties to a BigDoors Door!");
    }

    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("is_open") && mechanism.requireBoolean()) {
            if (this.door.isOpen() == mechanism.getValue().asBoolean() || BigDoorsBridge.commander.isDoorBusy(this.door.getDoorUID())) {
                return;
            }
            if (!BigDoorsBridge.bigDoors.areChunksLoadedForDoor(this.door)) {
                Debug.echoError((String)"Door chunks are not loaded. cannot open door.");
                return;
            }
            BigDoorsBridge.bigDoors.toggleDoor(this.door.getDoorUID());
            return;
        }
        if (mechanism.matches("is_locked") && mechanism.requireBoolean()) {
            BigDoorsBridge.commander.setLock(this.door.getDoorUID(), mechanism.getValue().asBoolean());
            return;
        }
        if (mechanism.matches("auto_close") && mechanism.requireObject(DurationTag.class)) {
            BigDoorsBridge.commander.updateDoorAutoClose(this.door.getDoorUID(), ((DurationTag)mechanism.valueAsType(DurationTag.class)).getSecondsAsInt());
        }
        if (!mechanism.fulfilled()) {
            mechanism.reportInvalid();
        }
    }
}

