/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.events.votifier;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.TimeTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.vexsoftware.votifier.model.Vote;
import com.vexsoftware.votifier.model.VotifierEvent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class VotifierVoteScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static VotifierVoteScriptEvent instance;
    public Vote vote;

    public VotifierVoteScriptEvent() {
        instance = this;
    }

    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        return path.eventLower.startsWith("votifier vote");
    }

    public String getName() {
        return "VotifierVote";
    }

    public ScriptEntryData getScriptEntryData() {
        Player player = Bukkit.getPlayerExact((String)this.vote.getUsername());
        return new BukkitScriptEntryData(player == null ? null : new PlayerTag(player), null);
    }

    public ObjectTag getContext(String name) {
        switch (name) {
            case "time": {
                Debug.echoError((String)"Deprecation notice: Use 'context.time_sent' (TimeTag) instead of 'context.time' (ElementTag) for votifier vote event.");
                return new ElementTag(this.vote.getTimeStamp());
            }
            case "time_sent": {
                return new TimeTag(Long.parseLong(this.vote.getTimeStamp()) * 1000L);
            }
            case "service": {
                return new ElementTag(this.vote.getServiceName());
            }
            case "username": {
                return new ElementTag(this.vote.getUsername());
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onVotifierEvent(VotifierEvent event) {
        this.vote = event.getVote();
        this.fire((Event)event);
    }
}

