/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.events.towny;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.depenizen.bukkit.objects.towny.TownTag;
import com.palmergames.bukkit.towny.event.PlayerEnterTownEvent;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class PlayerEntersTownScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerEntersTownScriptEvent instance;
    public PlayerEnterTownEvent event;
    public TownTag town;

    public PlayerEntersTownScriptEvent() {
        instance = this;
    }

    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        return path.eventLower.startsWith("towny player enters");
    }

    public boolean matches(ScriptEvent.ScriptPath path) {
        String name = path.eventArgAt(3);
        if (!name.equals("town") && !this.town.equals(TownTag.valueOf(name))) {
            return false;
        }
        return super.matches(path);
    }

    public String getName() {
        return "TownyPlayerEntersTown";
    }

    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData((Entity)this.event.getPlayer());
    }

    public ObjectTag getContext(String name) {
        if (name.equals("town")) {
            return this.town;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onTownyPlayerEntersTown(PlayerEnterTownEvent event) {
        try {
            if (!event.getTo().getTownyWorld().isUsingTowny()) {
                return;
            }
        }
        catch (NotRegisteredException e) {
            return;
        }
        this.town = TownTag.fromWorldCoord(event.getTo());
        this.event = event;
        this.fire((Event)event);
    }
}

