/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.events.skillapi;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.sucy.skill.api.event.PlayerSkillDowngradeEvent;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class SkillAPIPlayerDowngradesSkillScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static SkillAPIPlayerDowngradesSkillScriptEvent instance;
    public PlayerSkillDowngradeEvent event;
    public PlayerTag player;
    public ElementTag level;
    public ElementTag skill;
    public ElementTag refund;

    public SkillAPIPlayerDowngradesSkillScriptEvent() {
        instance = this;
    }

    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        return path.eventLower.startsWith("skillapi player downgrades");
    }

    public boolean matches(ScriptEvent.ScriptPath path) {
        String skill = path.eventArgLowerAt(3);
        if (!skill.equals("skill") && !skill.equals(CoreUtilities.toLowerCase((String)this.skill.asString()))) {
            return false;
        }
        if (!this.runInCheck(path, (Location)this.player.getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    public String getName() {
        return "SkillAPIPlayerDowngradesSkill";
    }

    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.player, null);
    }

    public ObjectTag getContext(String name) {
        switch (name) {
            case "level": {
                return this.level;
            }
            case "refund": {
                return this.refund;
            }
            case "skill_name": {
                return this.skill;
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onSkillAPIPlayerDowngradesSkill(PlayerSkillDowngradeEvent event) {
        if (!EntityTag.isPlayer((Entity)event.getPlayerData().getPlayer())) {
            return;
        }
        this.player = PlayerTag.mirrorBukkitPlayer((OfflinePlayer)event.getPlayerData().getPlayer());
        this.level = new ElementTag(event.getDowngradedSkill().getLevel());
        this.refund = new ElementTag(event.getRefund());
        this.skill = new ElementTag(event.getDowngradedSkill().getData().getName());
        this.event = event;
        this.fire((Event)event);
    }
}

