/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.events.noteblockapi;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.xxmicloxx.NoteBlockAPI.event.SongEndEvent;
import java.io.File;
import java.net.URLDecoder;
import java.nio.file.Path;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class NoteBlockAPISongEndsScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static NoteBlockAPISongEndsScriptEvent instance;
    public SongEndEvent event;

    public NoteBlockAPISongEndsScriptEvent() {
        instance = this;
    }

    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!path.eventLower.startsWith("noteblockapi song")) {
            return false;
        }
        if (!path.eventArgLowerAt(2).equals("ends") && !path.eventArgLowerAt(3).equals("ends")) {
            return false;
        }
        return super.matches(path);
    }

    public boolean matches(ScriptEvent.ScriptPath path) {
        String songName = path.eventArgLowerAt(2);
        return songName.equals("ends") || songName.equals(CoreUtilities.toLowerCase((String)this.getSongFileName()));
    }

    public String getName() {
        return "NoteBlockAPISongEnds";
    }

    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(null, null);
    }

    public String getSongFileName() {
        try {
            Path songPath = this.event.getSongPlayer().getSong().getPath().toPath();
            String directory = URLDecoder.decode(System.getProperty("user.dir"));
            Path denizenPath = new File(directory + "/plugins/Denizen/").toPath();
            String finalPath = denizenPath.relativize(songPath).toString();
            if (finalPath.endsWith(".nbs")) {
                finalPath = finalPath.substring(0, finalPath.length() - ".nbs".length());
            }
            return finalPath;
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
            return null;
        }
    }

    public ObjectTag getContext(String name) {
        if (name.equals("song")) {
            return new ElementTag(this.getSongFileName());
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onSongEndEvent(SongEndEvent event) {
        this.event = event;
        this.fire((Event)event);
    }
}

