/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.events.mcmmo;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.gmail.nossr50.events.experience.McMMOPlayerLevelChangeEvent;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class mcMMOPlayerLevelChangeScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static mcMMOPlayerLevelChangeScriptEvent instance;
    public McMMOPlayerLevelChangeEvent event;
    public PlayerTag player;
    public ElementTag skill;
    public int level;
    public String cause;

    public mcMMOPlayerLevelChangeScriptEvent() {
        instance = this;
    }

    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        return path.eventLower.startsWith("mcmmo player") && path.eventArgLowerAt(3).equals("level");
    }

    public boolean matches(ScriptEvent.ScriptPath path) {
        String eSkill = path.eventArgLowerAt(2);
        if (!eSkill.equals("skill") && !eSkill.equals(CoreUtilities.toLowerCase((String)this.skill.asString()))) {
            return false;
        }
        if (!this.runInCheck(path, (Location)this.player.getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    public String getName() {
        return "mcMMOPlayerLevelChanges";
    }

    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        if (determinationObj instanceof ElementTag && ((ElementTag)determinationObj).isInt()) {
            this.level = ((ElementTag)determinationObj).asInt();
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.player, null);
    }

    public ObjectTag getContext(String name) {
        switch (name) {
            case "skill": {
                return this.skill;
            }
            case "level": {
                return new ElementTag(this.level);
            }
            case "cause": {
                return new ElementTag(this.cause);
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onmcMMOPlayerLevelChanges(McMMOPlayerLevelChangeEvent event) {
        if (EntityTag.isNPC((Entity)event.getPlayer())) {
            return;
        }
        this.player = PlayerTag.mirrorBukkitPlayer((OfflinePlayer)event.getPlayer());
        this.level = event.getSkillLevel();
        this.cause = event.getXpGainReason().toString();
        this.skill = new ElementTag(event.getSkill().getName());
        this.event = event;
        this.fire((Event)event);
    }
}

