/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.events.magicspells;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.nisovin.magicspells.events.SpellCastedEvent;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class SpellCastedScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static SpellCastedScriptEvent instance;
    public SpellCastedEvent event;
    public EntityTag caster;
    private float power;
    private float cooldown;
    private ElementTag spell;

    public SpellCastedScriptEvent() {
        instance = this;
    }

    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!path.eventArgLowerAt(0).equals("magicspells")) {
            return false;
        }
        if (!path.eventArgLowerAt(2).equals("completes")) {
            return false;
        }
        if (!path.eventArgLowerAt(3).equals("spell")) {
            return false;
        }
        return this.couldMatchEntity(path.eventArgLowerAt(1));
    }

    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!SpellCastedScriptEvent.tryEntity((EntityTag)this.caster, (String)path.eventArgLowerAt(1))) {
            return false;
        }
        return super.matches(path);
    }

    public String getName() {
        return "SpellCastedEvent";
    }

    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.caster);
    }

    public ObjectTag getContext(String name) {
        switch (name) {
            case "power": {
                return new ElementTag(this.power);
            }
            case "caster": {
                return this.caster.getDenizenObject();
            }
            case "cooldown": {
                return new ElementTag(this.cooldown);
            }
            case "spell_name": {
                return this.spell;
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onPlayerCastsSpell(SpellCastedEvent event) {
        this.caster = new EntityTag((Entity)event.getCaster());
        this.power = event.getPower();
        this.cooldown = event.getCooldown();
        this.spell = new ElementTag(event.getSpell().getName());
        this.event = event;
        this.fire((Event)event);
    }
}

