/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.events.magicspells;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import com.nisovin.magicspells.events.SpellCastEvent;
import com.nisovin.magicspells.util.SpellReagents;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;

public class SpellCastScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static SpellCastScriptEvent instance;
    public SpellCastEvent event;
    public EntityTag caster;
    private ElementTag spell;

    public SpellCastScriptEvent() {
        instance = this;
    }

    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!path.eventArgLowerAt(0).equals("magicspells")) {
            return false;
        }
        if (!path.eventArgLowerAt(2).equals("casts")) {
            return false;
        }
        return this.couldMatchEntity(path.eventArgLowerAt(1));
    }

    public boolean matches(ScriptEvent.ScriptPath path) {
        String spellName = path.eventArgLowerAt(3);
        if (!spellName.equals("spell") && !spellName.equalsIgnoreCase(this.spell.asString())) {
            return false;
        }
        if (!SpellCastScriptEvent.tryEntity((EntityTag)this.caster, (String)path.eventArgLowerAt(1))) {
            return false;
        }
        return super.matches(path);
    }

    public String getName() {
        return "SpellCastEvent";
    }

    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        String determination = determinationObj.toString();
        if (determination.length() > 0 && !SpellCastScriptEvent.isDefaultDetermination((ObjectTag)determinationObj)) {
            String lower = CoreUtilities.toLowerCase((String)determination);
            if (lower.startsWith("power:")) {
                ElementTag num = new ElementTag(determination.substring("power:".length()));
                if (!num.isFloat()) {
                    Debug.echoError((String)"Determination for 'power' must be a valid decimal number.");
                    return false;
                }
                this.event.setPower(num.asFloat());
                return true;
            }
            if (lower.startsWith("cast_time:")) {
                ElementTag max = new ElementTag(determination.substring("cast_time:".length()));
                if (!max.isInt()) {
                    Debug.echoError((String)"Determination for 'cast_time' must be a valid number.");
                    return false;
                }
                this.event.setCastTime(max.asInt());
                return true;
            }
            if (lower.startsWith("cooldown:")) {
                ElementTag num = new ElementTag(determination.substring("cooldown:".length()));
                if (!num.isFloat()) {
                    Debug.echoError((String)"Determination for 'cooldown' must be a valid decimal number.");
                    return false;
                }
                this.event.setCooldown(num.asFloat());
                return true;
            }
            if (lower.equals("clear_reagents")) {
                this.event.setReagents(new SpellReagents());
                return true;
            }
            if (lower.startsWith("reagent:")) {
                String type = determination.substring("reagent:".length());
                String typeLower = CoreUtilities.toLowerCase((String)type);
                SpellReagents reagents = this.event.getReagents();
                if (reagents == null) {
                    reagents = new SpellReagents();
                }
                if (typeLower.startsWith("mana:")) {
                    reagents.setMana(new ElementTag(type.substring("mana:".length())).asInt());
                } else if (typeLower.startsWith("health:")) {
                    reagents.setHealth(new ElementTag(type.substring("health:".length())).asInt());
                } else if (typeLower.startsWith("hunger:")) {
                    reagents.setHunger(new ElementTag(type.substring("hunger:".length())).asInt());
                } else if (typeLower.startsWith("experience:")) {
                    reagents.setExperience(new ElementTag(type.substring("experience:".length())).asInt());
                } else if (typeLower.startsWith("levels:")) {
                    reagents.setLevels(new ElementTag(type.substring("levels:".length())).asInt());
                } else if (typeLower.startsWith("durability:")) {
                    reagents.setDurability(new ElementTag(type.substring("durability:".length())).asInt());
                } else if (typeLower.startsWith("money:")) {
                    reagents.setMoney(new ElementTag(type.substring("money:".length())).asFloat());
                } else if (typeLower.startsWith("variable:")) {
                    String variable = type.substring("variable:".length());
                    int ind = variable.indexOf(58);
                    if (reagents.getVariables() == null) {
                        reagents.setVariables(new HashMap());
                    }
                    reagents.getVariables().put(variable.substring(0, ind), new ElementTag(variable.substring(ind + 1)).asDouble());
                } else if (typeLower.startsWith("items:")) {
                    ArrayList<ItemStack> itemsToSet = new ArrayList<ItemStack>();
                    for (ItemTag item : ListTag.valueOf((String)type.substring("items:".length()), (TagContext)CoreUtilities.basicContext).filter(ItemTag.class, (Debuggable)path.container, true)) {
                        itemsToSet.add(item.getItemStack());
                    }
                    reagents.setItems(itemsToSet);
                }
                this.event.setReagents(reagents);
                return true;
            }
        }
        return super.applyDetermination(path, determinationObj);
    }

    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.caster);
    }

    public ObjectTag getContext(String name) {
        SpellReagents reagents;
        if (name.equals("power")) {
            return new ElementTag(this.event.getPower());
        }
        if (name.equals("caster")) {
            return this.caster.getDenizenObject();
        }
        if (name.equals("cast_time")) {
            return new ElementTag(this.event.getCastTime());
        }
        if (name.equals("cooldown")) {
            return new ElementTag(this.event.getCooldown());
        }
        if (name.equals("spell_name")) {
            return this.spell;
        }
        if (name.startsWith("spell_reagent_") && (reagents = this.event.getReagents()) != null) {
            switch (name) {
                case "spell_reagant_mana": {
                    return new ElementTag(reagents.getMana());
                }
                case "spell_reagant_health": {
                    return new ElementTag(reagents.getHealth());
                }
                case "spell_reagant_hunger": {
                    return new ElementTag(reagents.getHunger());
                }
                case "spell_reagant_experience": {
                    return new ElementTag(reagents.getExperience());
                }
                case "spell_reagant_levels": {
                    return new ElementTag(reagents.getLevels());
                }
                case "spell_reagant_durability": {
                    return new ElementTag(reagents.getDurability());
                }
                case "spell_reagant_money": {
                    return new ElementTag(reagents.getMoney());
                }
                case "spell_reagant_variables": {
                    ListTag list = new ListTag();
                    if (reagents.getVariables() != null) {
                        for (Map.Entry entry : reagents.getVariables().entrySet()) {
                            list.add((String)entry.getKey() + "/" + entry.getValue());
                        }
                    }
                    return list;
                }
                case "spell_reagant_items": {
                    ListTag list = new ListTag();
                    if (reagents.getItems() != null) {
                        for (ItemStack item : reagents.getItems()) {
                            list.addObject((ObjectTag)new ItemTag(item));
                        }
                    }
                    return list;
                }
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onPlayerCastsSpell(SpellCastEvent event) {
        this.caster = new EntityTag((Entity)event.getCaster());
        this.spell = new ElementTag(event.getSpell().getName());
        this.event = event;
        this.fire((Event)event);
    }
}

